/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.projects;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.orchestratorclient.tasks.AdaptedTransferProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.shadow.db.ProjectExportFinalStatus;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.projects.AbstractPlatformProjectProcessor;
import com.atlassian.jira.migration.workers.projects.AbstractProjectProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u00b5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J\b\u0010H\u001a\u000208H\u0016J\b\u0010I\u001a\u000209H\u0016J\b\u0010J\u001a\u000209H\u0016J\u0010\u0010K\u001a\u0002092\u0006\u0010L\u001a\u00020=H\u0002J\u0012\u0010M\u001a\u0002092\b\u0010N\u001a\u0004\u0018\u00010=H\u0016J\u0010\u0010O\u001a\u0002092\u0006\u0010P\u001a\u00020=H\u0002J\b\u0010Q\u001a\u000209H\u0002J\b\u0010R\u001a\u000209H\u0007R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\n 3*\u0004\u0018\u00010202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020907X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/atlassian/jira/migration/workers/projects/V3ProjectProcessor;", "Lcom/atlassian/jira/migration/workers/projects/AbstractPlatformProjectProcessor;", "export", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "attachmentMediaIdService", "Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "project", "Lcom/atlassian/jira/project/Project;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/project/Project;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;Ljava/util/concurrent/ScheduledExecutorService;)V", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "onProgressUpdate", "Lkotlin/Function1;", "", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "operationKeyPrefix", "", "getOperationKeyPrefix", "()Ljava/lang/String;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "getProject", "()Lcom/atlassian/jira/project/Project;", "projectTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/AdaptedTransferProjectTask;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "getHeartbeatFrequency", "process", "sendFinalStatus", "sendFinalStatusForShadowMigration", "migrationId", "sendHeartbeat", "msg", "sendSkippedStatus", "message", "setHeartbeatScheduler", "shutdown", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV3ProjectsWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3ProjectsWorker.kt\ncom/atlassian/jira/migration/workers/projects/V3ProjectProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n1#2:341\n*E\n"})
public final class V3ProjectProcessor
extends AbstractPlatformProjectProcessor {
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final Project project;
    @NotNull
    private final Task task;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    private final Logger log;
    @NotNull
    private final AdaptedTransferProjectTask projectTask;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final String operationKeyPrefix;
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;
    @NotNull
    private final Function1<Long, Unit> onProgressUpdate;

    public V3ProjectProcessor(@NotNull ExportFacade export2, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull AttachmentMediaIdService attachmentMediaIdService, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull DiscoveryService discoveryService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull IssueManager issueManager, @NotNull Project project, @NotNull Task task, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationFeatures migrationFeatures, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull PlatformService platformService, @NotNull MigrationServiceClient migrationServiceClient, @NotNull MigAssetStatsService migAssetStatsService, @NotNull AnalyticsEventService analyticsEventService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DataFiltersContextService dataFiltersContextService, @NotNull ScheduledExecutorService heartbeatScheduler) {
        Intrinsics.checkNotNullParameter((Object)export2, (String)"export");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)attachmentMediaIdService, (String)"attachmentMediaIdService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        super(export2, migrationScopeManager, migrationTaskMetadataProvider, attachmentMediaIdService, migrationEventBus, tombstoneAccountManager, discoveryService, localFileDataOutput, issueManager, project, task, usersMigrationServiceClient, metricsEventService, jiraEventDetectionService, platformService, migAssetStatsService, analyticsEventService, migrationServiceClient, dataFiltersContextService);
        this.discoveryService = discoveryService;
        this.project = project;
        this.task = task;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.migrationFeatures = migrationFeatures;
        this.platformService = platformService;
        this.migrationServiceClient = migrationServiceClient;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.dataFiltersContextService = dataFiltersContextService;
        this.heartbeatScheduler = heartbeatScheduler;
        this.log = LoggerFactory.getLogger(V3ProjectProcessor.class);
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.AdaptedTransferProjectTask");
        this.projectTask = (AdaptedTransferProjectTask)migrationTask;
        this.transferId = new TransferId(this.projectTask.getTransferId());
        this.operationKeyPrefix = "prj-" + this.task.getMigrationId() + '-' + this.getProject().getKey() + '-' + UUID.randomUUID();
        this.heartbeater = new PlatformHeartbeater(this.platformService, this.getContainerToken(), this.projectTask.getHeartbeatUrl(), null, null, 24, null);
        this.progressUpdater = new PlatformProgressUpdater(this.platformService, this.getMigrationId(), this.transferId, this.getContainerToken(), null, null, 48, null);
        this.onProgressUpdate = (Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ V3ProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long issuesExported) {
                AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                long l = this.this$0.getTotalIssueCount().calculateAndGet(issuesExported);
                V3ProjectProcessor v3ProjectProcessor = this.this$0;
                long total = l;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)total)};
                PlatformProgressUpdater.sendProgressUpdate$default(V3ProjectProcessor.access$getProgressUpdater$p(v3ProjectProcessor), LongExtensionsKt.rangedPercentOf$default(issuesExported, total, 0, 0, 6, null), "", MapsKt.mapOf((Pair[])pairArray), false, 8, null);
            }
        };
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public String getOperationKeyPrefix() {
        return this.operationKeyPrefix;
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            if (!this.migrationFeatures.getSkipProjectExportIfPresentInCloud() || plan2.getMigrationType() == MigrationType.INCREMENTAL) {
                super.process();
                return;
            }
            if (this.getConflictingProjects().isEmpty()) {
                super.process();
                return;
            }
            this.sendSkippedStatus("Project with key '" + this.getProject().getKey() + "' and name '" + this.getProject().getName() + "' is already present in cloud. Hence, skipping it.");
        }
        catch (Exception ex) {
            this.getLog().error("Error processing project export for project " + this.getProject().getKey(), (Throwable)ex);
            throw ex;
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    private final void setHeartbeatScheduler() {
        if (this.migrationFeatures.getEnableV3AsyncHeartbeat()) {
            this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ V3ProjectProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    V3ProjectProcessor.access$getHeartbeater$p(this.this$0).sendHeartbeat();
                }
            }), this.task, MigrationProtocol.V3), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
        }
    }

    @Override
    @NotNull
    public Function1<Long, Unit> getOnProgressUpdate() {
        return this.onProgressUpdate;
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        MigrationFinalStatus migrationFinalStatus = this.migrationFinalStatusRepository.getShadowMigrationMetadata(migrationId, this.task.getMigrationTask().getMigrationTaskType(), this.getProject().getId());
        if (migrationFinalStatus == null) {
            PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        ProjectExportFinalStatus cfr_ignored_0 = (ProjectExportFinalStatus)finalStatus;
        Pair[] pairArray = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(((ProjectExportFinalStatus)finalStatus).getIssuesExported(), ((ProjectExportFinalStatus)finalStatus).getIssuesTotal(), 0, 0, 6, null);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesExported()), TuplesKt.to((Object)"issuesTotal", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesTotal())};
        Map map = MapsKt.mapOf((Pair[])pairArray2);
        pairArray.sendProgressUpdate(n, "", map, true);
        pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)((ProjectExportFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"deletedUsersMappings", (Object)((ProjectExportFinalStatus)finalStatus).getDeletedUserMappingFile()), TuplesKt.to((Object)"tombstoneUsers", (Object)((ProjectExportFinalStatus)finalStatus).getTombstoneUserFile()), TuplesKt.to((Object)"issuesExported", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesExported()), TuplesKt.to((Object)"issuesTotal", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesTotal())};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        String string = msg;
        if (string != null && (string = StringExtensionsKt.takeUnlessNullOrBlank(string)) != null) {
            String progressMessage = string;
            boolean bl = false;
            long issuesExported = this.progressUpdater.getProgressEntityCount("issuesExported");
            long issuesTotal = this.progressUpdater.getProgressEntityCount("issuesTotal");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
            PlatformProgressUpdater.sendProgressUpdate$default(this.progressUpdater, LongExtensionsKt.rangedPercentOf$default(issuesExported, issuesTotal, 0, 0, 6, null), progressMessage, MapsKt.mapOf((Pair[])pairArray), false, 8, null);
        }
        this.heartbeater.sendHeartbeat();
    }

    @Override
    public void sendFinalStatus() {
        long issuesExported = this.progressUpdater.getProgressEntityCount("issuesExported");
        long issuesTotal = this.progressUpdater.getProgressEntityCount("issuesTotal");
        Pair[] pairArray = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(issuesExported, issuesTotal, 0, 0, 6, null);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
        Map map = MapsKt.mapOf((Pair[])pairArray2);
        pairArray.sendProgressUpdate(n, "", map, true);
        String string = ((UUID)this.getMigrationId().getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.migrationFinalStatusRepository.create(string, new ProjectExportFinalStatus(this.getFileId(), this.getDeletedUsersFile().getFileId(), this.getTombstoneUsersFile().getFileId(), issuesExported, issuesTotal), this.getProject().getId());
        pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)this.getFileId()), TuplesKt.to((Object)"deletedUsersMappings", (Object)this.getDeletedUsersFile().getFileId()), TuplesKt.to((Object)"tombstoneUsers", (Object)this.getTombstoneUsersFile().getFileId()), TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    @Override
    public long getHeartbeatFrequency() {
        return 10L;
    }

    private final void sendSkippedStatus(String message) {
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SKIPPED, null, message, 2, null);
    }

    public static final /* synthetic */ PlatformHeartbeater access$getHeartbeater$p(V3ProjectProcessor $this) {
        return $this.heartbeater;
    }

    public static final /* synthetic */ PlatformProgressUpdater access$getProgressUpdater$p(V3ProjectProcessor $this) {
        return $this.progressUpdater;
    }
}

