/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.projects;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.shadow.db.ProjectExportFinalStatus;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.projects.AbstractPlatformProjectProcessor;
import com.atlassian.jira.migration.workers.projects.AbstractProjectProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u00d5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020-\u0012\u0006\u0010.\u001a\u00020/\u0012\u0006\u00100\u001a\u000201\u0012\u0006\u00102\u001a\u000203\u0012\u0006\u00104\u001a\u000205\u00a2\u0006\u0002\u00106J\b\u0010J\u001a\u00020>H\u0016J\b\u0010K\u001a\u00020?H\u0016J\b\u0010L\u001a\u00020?H\u0016J\u0010\u0010M\u001a\u00020?2\u0006\u0010N\u001a\u00020CH\u0002J\u0012\u0010O\u001a\u00020?2\b\u0010P\u001a\u0004\u0018\u00010CH\u0016J\u0010\u0010Q\u001a\u00020?2\u0006\u0010R\u001a\u00020CH\u0002J\b\u0010S\u001a\u00020?H\u0002J\b\u0010T\u001a\u00020?H\u0007R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\n 9*\u0004\u0018\u00010808X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020CX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/atlassian/jira/migration/workers/projects/V4ProjectProcessor;", "Lcom/atlassian/jira/migration/workers/projects/AbstractPlatformProjectProcessor;", "export", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "attachmentMediaIdService", "Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "project", "Lcom/atlassian/jira/project/Project;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/project/Project;Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Ljava/util/concurrent/ScheduledExecutorService;Lcom/atlassian/jira/migration/migration/MigrationProtocol;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "onProgressUpdate", "Lkotlin/Function1;", "", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "operationKeyPrefix", "", "getOperationKeyPrefix", "()Ljava/lang/String;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "getProject", "()Lcom/atlassian/jira/project/Project;", "getHeartbeatFrequency", "process", "sendFinalStatus", "sendFinalStatusForShadowMigration", "migrationId", "sendHeartbeat", "msg", "sendSkippedStatus", "message", "setHeartbeatScheduler", "shutdown", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV4ProjectProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V4ProjectProcessor.kt\ncom/atlassian/jira/migration/workers/projects/V4ProjectProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public final class V4ProjectProcessor
extends AbstractPlatformProjectProcessor {
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final Project project;
    @NotNull
    private final PrcTask task;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    private final Logger log;
    @NotNull
    private final String operationKeyPrefix;
    @NotNull
    private final PrcProgressUpdater progressUpdater;
    @NotNull
    private final Function1<Long, Unit> onProgressUpdate;

    public V4ProjectProcessor(@NotNull ExportFacade export2, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull AttachmentMediaIdService attachmentMediaIdService, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull DiscoveryService discoveryService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull IssueManager issueManager, @NotNull Project project, @NotNull PrcTask task, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationFeatures migrationFeatures, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull PlatformService platformService, @NotNull MigrationServiceClient migrationServiceClient, @NotNull MigAssetStatsService migAssetStatsService, @NotNull AnalyticsEventService analyticsEventService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull ScheduledExecutorService heartbeatScheduler, @NotNull MigrationProtocol migrationProtocol, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)export2, (String)"export");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)attachmentMediaIdService, (String)"attachmentMediaIdService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationProtocol), (String)"migrationProtocol");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        super(export2, migrationScopeManager, migrationTaskMetadataProvider, attachmentMediaIdService, migrationEventBus, tombstoneAccountManager, discoveryService, localFileDataOutput, issueManager, project, task, usersMigrationServiceClient, metricsEventService, jiraEventDetectionService, platformService, migAssetStatsService, analyticsEventService, migrationServiceClient, dataFiltersContextService);
        this.discoveryService = discoveryService;
        this.project = project;
        this.task = task;
        this.migrationFeatures = migrationFeatures;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.heartbeatScheduler = heartbeatScheduler;
        this.migrationProtocol = migrationProtocol;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.dataFiltersContextService = dataFiltersContextService;
        this.log = LoggerFactory.getLogger(V4ProjectProcessor.class);
        this.operationKeyPrefix = "prj-" + this.task.getMigrationId() + '-' + this.getProject().getKey() + '-' + UUID.randomUUID();
        this.progressUpdater = new PrcProgressUpdater(this.prcStatusUpdateService, this.getMigrationId(), this.migrationCommandService, this.migrationIds, null, null, 48, null);
        this.onProgressUpdate = (Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ V4ProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long issuesExported) {
                AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                long l = this.this$0.getTotalIssueCount().calculateAndGet(issuesExported);
                V4ProjectProcessor v4ProjectProcessor = this.this$0;
                long total = l;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)total)};
                PrcProgressUpdater.sendProgressUpdate$default(V4ProjectProcessor.access$getProgressUpdater$p(v4ProjectProcessor), LongExtensionsKt.rangedPercentOf$default(issuesExported, total, 0, 0, 6, null), "", MapsKt.mapOf((Pair[])pairArray), false, V4ProjectProcessor.access$getTask$p(v4ProjectProcessor), 8, null);
            }
        };
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public String getOperationKeyPrefix() {
        return this.operationKeyPrefix;
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            this.getLog().info("Project processing started " + this.task.getMigrationId() + '-' + this.getProject().getKey() + " prcCommandId: " + this.task.getPrcCommandId() + '}');
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            if (!this.migrationFeatures.getSkipProjectExportIfPresentInCloud() || plan2.getMigrationType() == MigrationType.INCREMENTAL) {
                super.process();
                return;
            }
            if (this.getConflictingProjects().isEmpty()) {
                super.process();
                return;
            }
            this.sendSkippedStatus("Project with key '" + this.getProject().getKey() + "' and name '" + this.getProject().getName() + "' is already present in cloud. Hence, skipping it.");
        }
        catch (CommandCancelledException ex) {
            this.getLog().warn(ex.getMessage());
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    private final void setHeartbeatScheduler() {
        this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ V4ProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                V4ProjectProcessor.access$getPrcStatusUpdateService$p(this.this$0).sendHeartbeat(V4ProjectProcessor.access$getTask$p(this.this$0));
            }
        }), this.task, this.migrationProtocol), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
    }

    @Override
    @NotNull
    public Function1<Long, Unit> getOnProgressUpdate() {
        return this.onProgressUpdate;
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        MigrationFinalStatus migrationFinalStatus = this.migrationFinalStatusRepository.getShadowMigrationMetadata(migrationId, this.task.getMigrationTask().getMigrationTaskType(), this.getProject().getId());
        if (migrationFinalStatus == null) {
            PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", this.task, 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        ProjectExportFinalStatus cfr_ignored_0 = (ProjectExportFinalStatus)finalStatus;
        Pair[] pairArray = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(((ProjectExportFinalStatus)finalStatus).getIssuesExported(), ((ProjectExportFinalStatus)finalStatus).getIssuesTotal(), 0, 0, 6, null);
        Object object = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesExported()), TuplesKt.to((Object)"issuesTotal", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesTotal())};
        Map map = MapsKt.mapOf((Pair[])object);
        object = this.task;
        pairArray.sendProgressUpdate(n, "", map, true, (PrcTask)object);
        pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)((ProjectExportFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"deletedUsersMappings", (Object)((ProjectExportFinalStatus)finalStatus).getDeletedUserMappingFile()), TuplesKt.to((Object)"tombstoneUsers", (Object)((ProjectExportFinalStatus)finalStatus).getTombstoneUserFile()), TuplesKt.to((Object)"issuesExported", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesExported()), TuplesKt.to((Object)"issuesTotal", (Object)((ProjectExportFinalStatus)finalStatus).getIssuesTotal())};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        block0: {
            String string = msg;
            if (string == null || (string = StringExtensionsKt.takeUnlessNullOrBlank(string)) == null) break block0;
            String progressMessage = string;
            boolean bl = false;
            long issuesExported = this.progressUpdater.getProgressEntityCount("issuesExported");
            long issuesTotal = this.progressUpdater.getProgressEntityCount("issuesTotal");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
            PrcProgressUpdater.sendProgressUpdate$default(this.progressUpdater, LongExtensionsKt.rangedPercentOf$default(issuesExported, issuesTotal, 0, 0, 6, null), progressMessage, MapsKt.mapOf((Pair[])pairArray), false, this.task, 8, null);
        }
    }

    @Override
    public long getHeartbeatFrequency() {
        return 1L;
    }

    @Override
    public void sendFinalStatus() {
        long issuesExported = this.progressUpdater.getProgressEntityCount("issuesExported");
        long issuesTotal = this.progressUpdater.getProgressEntityCount("issuesTotal");
        Pair[] pairArray = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(issuesExported, issuesTotal, 0, 0, 6, null);
        Object object = new Pair[]{TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
        Map map = MapsKt.mapOf((Pair[])object);
        object = this.task;
        pairArray.sendProgressUpdate(n, "", map, true, (PrcTask)object);
        String string = ((UUID)this.getMigrationId().getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.migrationFinalStatusRepository.create(string, new ProjectExportFinalStatus(this.getFileId(), this.getDeletedUsersFile().getFileId(), this.getTombstoneUsersFile().getFileId(), issuesExported, issuesTotal), this.getProject().getId());
        pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)this.getFileId()), TuplesKt.to((Object)"deletedUsersMappings", (Object)this.getDeletedUsersFile().getFileId()), TuplesKt.to((Object)"tombstoneUsers", (Object)this.getTombstoneUsersFile().getFileId()), TuplesKt.to((Object)"issuesExported", (Object)issuesExported), TuplesKt.to((Object)"issuesTotal", (Object)issuesTotal)};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    private final void sendSkippedStatus(String message) {
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SKIPPED, null, message, this.task, 2, null);
    }

    public static final /* synthetic */ PrcStatusUpdateService access$getPrcStatusUpdateService$p(V4ProjectProcessor $this) {
        return $this.prcStatusUpdateService;
    }

    public static final /* synthetic */ PrcTask access$getTask$p(V4ProjectProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ PrcProgressUpdater access$getProgressUpdater$p(V4ProjectProcessor $this) {
        return $this.progressUpdater;
    }
}

