/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.LASAllowedFiles;
import com.atlassian.jira.migration.workers.site.FileUploadPreparer;
import com.atlassian.jira.migration.workers.site.PreparedFile;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/workers/site/LZ4UploadPreparer;", "Lcom/atlassian/jira/migration/workers/site/FileUploadPreparer;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "compressFile", "Ljava/io/File;", "file", "getLZ4OutputStream", "Lnet/jpountz/lz4/LZ4FrameOutputStream;", "prepare", "", "Lcom/atlassian/jira/migration/workers/site/PreparedFile;", "pathToFile", "Ljava/nio/file/Path;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nLZ4UploadPreparer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LZ4UploadPreparer.kt\ncom/atlassian/jira/migration/workers/site/LZ4UploadPreparer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n1#2:79\n18#3:80\n26#4:81\n3792#5:82\n4307#5,2:83\n3792#5:91\n4307#5,2:92\n1208#6,2:85\n1238#6,4:87\n1208#6,2:94\n1238#6,4:96\n125#7:100\n152#7,3:101\n125#7:104\n152#7,3:105\n*S KotlinDebug\n*F\n+ 1 LZ4UploadPreparer.kt\ncom/atlassian/jira/migration/workers/site/LZ4UploadPreparer\n*L\n36#1:80\n36#1:81\n40#1:82\n40#1:83,2\n45#1:91\n45#1:92,2\n41#1:85,2\n41#1:87,4\n46#1:94,2\n46#1:96,4\n48#1:100\n48#1:101,3\n49#1:104\n49#1:105,3\n*E\n"})
public final class LZ4UploadPreparer
implements FileUploadPreparer {
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public LZ4UploadPreparer(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PreparedFile> prepare(@NotNull Path pathToFile) {
        Map $this$mapTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        File file2;
        Object object2;
        void $this$associateByTo$iv$iv2;
        void $this$associateBy$iv2;
        Object it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        File[] localFiles;
        Intrinsics.checkNotNullParameter((Object)pathToFile, (String)"pathToFile");
        if (!this.migrationFeatures.getEnableSinglePathLZ4MCS()) {
            throw new IllegalStateException("LZ4 is not enabled".toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(pathToFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-check-LZ4UploadPreparer$prepare$22 = false;
            String $i$a$-check-LZ4UploadPreparer$prepare$22 = "Failed to prepare upload, directory doesn't exist, " + pathToFile;
            throw new IllegalStateException($i$a$-check-LZ4UploadPreparer$prepare$22.toString());
        }
        File[] $this$orEmpty$iv = pathToFile.toFile().listFiles();
        boolean $i$f$orEmpty22 = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            fileArray = new File[]{};
        }
        File[] $i$f$orEmpty22 = localFiles = fileArray;
        boolean $i$f$filter = false;
        void var6_10 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = element$iv$iv;
            boolean bl = false;
            if (!LASAllowedFiles.INSTANCE.getNON_LZ4_FILES().contains(((File)it).getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            it = (File)element$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            String string = ((File)it).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Intrinsics.checkNotNull((Object)LASAllowedFiles.INSTANCE.getCompressedLZ4Filename(string));
            it = (File)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            file2 = this.compressFile((File)it);
            object2.put(object, file2);
        }
        Map systemCompressedFiles = destination$iv$iv2;
        File[] $i$f$associateBy22 = localFiles;
        boolean $i$f$filter2 = false;
        $this$associateByTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void it2 = element$iv$iv;
            boolean bl = false;
            if (!(LASAllowedFiles.INSTANCE.getLZ4_FILES().contains(it2.getName()) && !systemCompressedFiles.containsKey(it2.getName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            File it2 = (File)element$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            it2 = (File)element$iv$iv;
            object = it2.getName();
            boolean bl3 = false;
            file2 = it2;
            object2.put(object, file2);
        }
        Map localCompressedFiles = destination$iv$iv3;
        Map $this$map$iv = systemCompressedFiles;
        boolean $i$f$map = false;
        Map capacity$iv22 = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            Object element$iv$iv;
            element$iv$iv = item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(new PreparedFile((String)it.getKey(), (File)it.getValue(), true));
        }
        $this$map$iv = localCompressedFiles;
        object2 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            object.add(new PreparedFile(string, (File)v, false));
        }
        return CollectionsKt.plus((Collection)object2, (Iterable)((List)destination$iv$iv2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File compressFile(File file2) {
        File outputFile = new File(file2.getAbsolutePath() + '.' + System.currentTimeMillis() + ".lz4");
        Closeable closeable = new FileInputStream(file2);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)this.getLZ4OutputStream(outputFile);
            Throwable throwable2 = null;
            try {
                LZ4FrameOutputStream outputStream = (LZ4FrameOutputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[2048];
                int len = 0;
                while (true) {
                    int n;
                    int it = n = inputStream.read(buffer);
                    boolean bl3 = false;
                    len = it;
                    if (n == -1) break;
                    outputStream.write(buffer, 0, len);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return outputFile;
    }

    @VisibleForTesting
    @NotNull
    public final LZ4FrameOutputStream getLZ4OutputStream(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        LZ4FrameOutputStream.FLG.Bits[] bitsArray = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE};
        return new LZ4FrameOutputStream((OutputStream)new FileOutputStream(file2), LZ4FrameOutputStream.BLOCKSIZE.SIZE_4MB, -1L, LZ4Factory.fastestInstance().highCompressor(9), XXHashFactory.fastestInstance().hash32(), bitsArray);
    }
}

