/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.utility.FileChunkUtility;
import com.atlassian.jira.migration.workers.site.FileUploader;
import com.atlassian.jira.migration.workers.site.LZ4UploadPreparer;
import com.atlassian.jira.migration.workers.site.PreparedFile;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/workers/site/MCSFileUploader;", "Lcom/atlassian/jira/migration/workers/site/FileUploader;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "uploadPreparer", "Lcom/atlassian/jira/migration/workers/site/LZ4UploadPreparer;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/workers/site/LZ4UploadPreparer;)V", "generateAndUploadManifest", "", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "filenameToMCSMap", "", "upload", "Lcom/atlassian/jira/migration/workers/site/FileUploader$Companion$FileUploadResult;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "exportPath", "Ljava/nio/file/Path;", "uploadFile", "preparedFile", "Lcom/atlassian/jira/migration/workers/site/PreparedFile;", "validateFiles", "", "files", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMCSFileUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MCSFileUploader.kt\ncom/atlassian/jira/migration/workers/site/MCSFileUploader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1208#2,2:122\n1238#2,4:124\n1747#2,3:128\n1747#2,3:132\n1#3:131\n*S KotlinDebug\n*F\n+ 1 MCSFileUploader.kt\ncom/atlassian/jira/migration/workers/site/MCSFileUploader\n*L\n45#1:122,2\n45#1:124,4\n65#1:128,3\n66#1:132,3\n*E\n"})
public final class MCSFileUploader
implements FileUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final LZ4UploadPreparer uploadPreparer;
    private static final Logger log = LoggerFactory.getLogger(MCSFileUploader.class);
    @NotNull
    private static final String MANIFEST_FILE = "manifest.txt";

    @Inject
    public MCSFileUploader(@NotNull PlatformService platformService, @NotNull MigrationFeatures migrationFeatures, @NotNull LZ4UploadPreparer uploadPreparer) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)uploadPreparer, (String)"uploadPreparer");
        this.platformService = platformService;
        this.migrationFeatures = migrationFeatures;
        this.uploadPreparer = uploadPreparer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileUploader.Companion.FileUploadResult upload(@NotNull Task task, @NotNull Path exportPath) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        ContainerToken containerToken = new ContainerToken(task.getCloudSite().getContainerToken());
        MigrationId migrationId = new MigrationId(task.getMigrationId());
        try {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            List<PreparedFile> preparedFiles = this.uploadPreparer.prepare(exportPath);
            this.validateFiles(preparedFiles);
            Iterable iterable = preparedFiles;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var10_10 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                PreparedFile preparedFile = (PreparedFile)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                PreparedFile it = (PreparedFile)element$iv$iv;
                String string = it.getTargetFile();
                boolean bl2 = false;
                String string2 = this.uploadFile(it, containerToken, migrationId);
                map.put(string, string2);
            }
            Map filenameToMCSMap = destination$iv$iv;
            String fileId = this.generateAndUploadManifest(containerToken, migrationId, filenameToMCSMap);
            return new FileUploader.Companion.FileUploadResult(MANIFEST_FILE, fileId, true);
        }
        catch (Exception e) {
            log.error("MCS file upload failed: " + task.getMigrationId() + ", taskId: " + task.getTaskId());
            log.error(e.getMessage());
            return new FileUploader.Companion.FileUploadResult(null, null, false, 3, null);
        }
    }

    private final void validateFiles(List<PreparedFile> files) {
        boolean bl;
        block9: {
            PreparedFile it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block8: {
                $this$any$iv = files;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PreparedFile)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getTargetFile(), (Object)"entities.xml.lz4")) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                boolean $i$a$-check-MCSFileUploader$validateFiles$32 = false;
                String $i$a$-check-MCSFileUploader$validateFiles$32 = "Upload validation failed, missing entities.xml.lz4";
                throw new IllegalStateException($i$a$-check-MCSFileUploader$validateFiles$32.toString());
            }
            $this$any$iv = files;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PreparedFile)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getTargetFile(), (Object)"activeobjects.xml.lz4")) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (!bl) {
            boolean bl5 = false;
            String string = "Upload validation failed, missing activeobjects.xml.lz4";
            throw new IllegalStateException(string.toString());
        }
    }

    private final String uploadFile(PreparedFile preparedFile, ContainerToken containerToken, MigrationId migrationId) {
        String string;
        block0: {
            PreparedFile preparedFile2;
            File localFile = preparedFile.getLocalFile();
            int chunkSize = FileChunkUtility.INSTANCE.calculateChunkSize(localFile.length());
            log.info("Chunk size is " + chunkSize / 0x100000 + "MB");
            String it = string = !this.migrationFeatures.getDisableSinglePathLZ4MCSParallelUpload() ? PlatformUploadServiceInterface.DefaultImpls.uploadMultiPartInParallel$default(this.platformService, containerToken, migrationId, localFile.getName(), null, localFile, new PlatformService.MultiPartParallelUploadOption(chunkSize, 0, 0, 6, null), null, 64, null) : PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default(this.platformService, containerToken, migrationId, localFile.getName(), null, localFile, chunkSize, null, 64, null);
            boolean bl = false;
            PreparedFile file2 = preparedFile2 = preparedFile;
            boolean bl2 = false;
            Object object = file2.getSystemGenerated() ? preparedFile2 : null;
            if (object == null || (object = ((PreparedFile)object).getLocalFile()) == null) break block0;
            ((File)object).delete();
        }
        return string;
    }

    private final String generateAndUploadManifest(ContainerToken containerToken, MigrationId migrationId, Map<String, String> filenameToMCSMap) {
        String string;
        log.info("Uploading manifest file");
        String it = string = PlatformUploadServiceInterface.DefaultImpls.createFileAndUploadData$default(this.platformService, containerToken, migrationId, filenameToMCSMap, MANIFEST_FILE, null, null, 32, null);
        boolean bl = false;
        log.info("Uploaded manifest: " + it);
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/site/MCSFileUploader$Companion;", "", "()V", "MANIFEST_FILE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

