/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.core.util.DataUtils;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.orchestratorclient.tasks.JiraSiteDataUpload;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.AttachmentFilters;
import com.atlassian.jira.migration.plan.IssueFilters;
import com.atlassian.jira.migration.plan.LiftAndShiftMode;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.migration.workers.site.V3SiteDataWorker;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003)*+B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ<\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0019J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J,\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u0010#\u001a\u00020\u0013H\u0002J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator;", "", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "siteDataWorker", "Lcom/atlassian/jira/migration/workers/site/V3SiteDataWorker;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/workers/site/V3SiteDataWorker;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportManual", "Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$ManualInterventionExportResult;", "planId", "", "planName", "preflightsToOverride", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "waitForPreflights", "", "skipAllChecks", "generateExportFile", "Ljava/nio/file/Path;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "isWithoutAttachments", "getContinueWithExportResult", "Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$ContinueWithExportResult;", "failedCheckTypes", "getExportFileName", "getPreflightResult", "Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$PreflightStatusResult;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "runPreflightChecks", "ContinueWithExportResult", "ManualInterventionExportResult", "PreflightStatusResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nManualInterventionExportGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualInterventionExportGenerator.kt\ncom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1#2:224\n1#2:238\n819#3:225\n847#3,2:226\n1603#3,9:228\n1855#3:237\n1856#3:239\n1612#3:240\n*S KotlinDebug\n*F\n+ 1 ManualInterventionExportGenerator.kt\ncom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator\n*L\n72#1:238\n71#1:225\n71#1:226,2\n72#1:228,9\n72#1:237\n72#1:239\n72#1:240\n*E\n"})
public final class ManualInterventionExportGenerator {
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final V3SiteDataWorker siteDataWorker;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;

    @Inject
    public ManualInterventionExportGenerator(@NotNull PreflightService preflightService, @NotNull V3SiteDataWorker siteDataWorker, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull PlanRepository planRepository, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)siteDataWorker, (String)"siteDataWorker");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.preflightService = preflightService;
        this.siteDataWorker = siteDataWorker;
        this.cloudSiteRepository = cloudSiteRepository;
        this.planRepository = planRepository;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(ManualInterventionExportGenerator.class);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ManualInterventionExportResult exportManual(@Nullable String planId, @Nullable String planName, @NotNull Set<? extends CheckType> preflightsToOverride, boolean waitForPreflights, boolean skipAllChecks) {
        Intrinsics.checkNotNullParameter(preflightsToOverride, (String)"preflightsToOverride");
        if (!(planId != null || planName != null)) {
            $i$a$-check-ManualInterventionExportGenerator$exportManual$1 = false;
            $i$a$-check-ManualInterventionExportGenerator$exportManual$1 = "Either plan name or plan id must not be null.";
            throw new IllegalStateException($i$a$-check-ManualInterventionExportGenerator$exportManual$1.toString());
        }
        if (planId != null) {
            v0 = this.planRepository.get(planId);
        } else {
            v1 = planName;
            Intrinsics.checkNotNull((Object)v1);
            v0 = this.planRepository.getByName(v1);
        }
        if ((plan = v0) == null) {
            $i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$2 = false;
            $i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$2 = "Plan not found. Make sure it exists in JCMA.";
            throw new IllegalStateException($i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$2.toString());
        }
        cloudSite = this.cloudSiteRepository.getSite(plan.getCloudId());
        if (cloudSite == null) {
            $i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$3 = false;
            $i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$3 = "Cloud site not found. Make sure to connect to it in JCMA.";
            throw new IllegalStateException($i$a$-checkNotNull-ManualInterventionExportGenerator$exportManual$3.toString());
        }
        if (!plan.isLiftAndShift()) {
            $i$a$-check-ManualInterventionExportGenerator$exportManual$4 = false;
            $i$a$-check-ManualInterventionExportGenerator$exportManual$4 = "Plan must be of lift and shift type (migrate all data at once).";
            throw new IllegalStateException($i$a$-check-ManualInterventionExportGenerator$exportManual$4.toString());
        }
        preflightResult = this.getPreflightResult(plan, waitForPreflights, skipAllChecks);
        var10_18 = preflightResult.getPreflightStatusList();
        if (var10_18 == null || (var11_19 = var10_18.statuses) == null) ** GOTO lbl-1000
        var13_20 = var11_19;
        $i$f$filterNot = false;
        var15_24 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (CheckStatus)element$iv$iv;
            $i$a$-filterNot-ManualInterventionExportGenerator$exportManual$failedCheckTypes$1 = false;
            if (it.checkResult.success) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $i$f$filterNot = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var21_35 = $this$forEach$iv$iv$iv.iterator();
        while (var21_35.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var21_35.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            it = (CheckStatus)element$iv$iv;
            $i$a$-mapNotNull-ManualInterventionExportGenerator$exportManual$failedCheckTypes$2 = false;
            v2 = it.checkType;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"checkType");
            if (CheckType.valueOf(v2) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var14_23 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (var14_23 != null) {
            v3 = var14_23;
        } else lbl-1000:
        // 2 sources

        {
            v3 = SetsKt.emptySet();
        }
        failedCheckTypes = v3;
        exportFile = null;
        continueWithExportResult = this.getContinueWithExportResult(skipAllChecks, failedCheckTypes, preflightsToOverride);
        message = continueWithExportResult.getMessage();
        isWithoutAttachments = MigrationModeUtil.INSTANCE.isWithoutAttachments(plan.isTestMigrationWithoutAttachments(), this.migrationFeatures);
        if (continueWithExportResult.getContinueWithExport()) {
            this.log.info("Generating export file...");
            exportFile = this.generateExportFile(cloudSite, isWithoutAttachments);
            this.log.info("Finished generating export file.");
            message = message + (exportFile != null ? " Created export file(s)." : " Attempted to create export file(s).");
        }
        if ((v4 = exportFile) == null || (v4 = v4.toAbsolutePath().toString()) == null) {
            v4 = "";
        }
        if ((v5 = preflightResult.getThrowableError()) == null || (v5 = ExceptionsKt.stackTraceToString((Throwable)v5)) == null) {
            v5 = "";
        }
        return new ManualInterventionExportResult(message, (String)v4, failedCheckTypes, (String)v5, preflightResult.getPreflightStatusList(), isWithoutAttachments);
    }

    public static /* synthetic */ ManualInterventionExportResult exportManual$default(ManualInterventionExportGenerator manualInterventionExportGenerator, String string, String string2, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return manualInterventionExportGenerator.exportManual(string, string2, set, bl, bl2);
    }

    private final PreflightStatusResult getPreflightResult(Plan plan2, boolean waitForPreflights, boolean skipAllChecks) {
        PreflightStatusResult preflightStatusResult;
        if (skipAllChecks) {
            PreflightStatusResult preflightStatusResult2;
            PreflightStatusResult it = preflightStatusResult2 = new PreflightStatusResult(null, new CheckExecutionStatus(plan2.getId(), CollectionsKt.emptyList()));
            boolean bl = false;
            this.log.info("Skipping preflight checks.");
            preflightStatusResult = preflightStatusResult2;
        } else {
            PreflightStatusResult preflightStatusResult3;
            this.log.info("Running preflight checks...");
            PreflightStatusResult it = preflightStatusResult3 = this.runPreflightChecks(plan2, waitForPreflights);
            boolean bl = false;
            this.log.info("Finished running preflight checks.");
            preflightStatusResult = preflightStatusResult3;
        }
        return preflightStatusResult;
    }

    private final ContinueWithExportResult getContinueWithExportResult(boolean skipAllChecks, Set<? extends CheckType> failedCheckTypes, Set<? extends CheckType> preflightsToOverride) {
        boolean continueWithExport = false;
        String message = null;
        if (skipAllChecks) {
            continueWithExport = true;
            message = "Skipped all preflight checks.";
        } else if (failedCheckTypes.isEmpty()) {
            continueWithExport = true;
            message = "All checks succeeded.";
        } else if (preflightsToOverride.containsAll((Collection)failedCheckTypes)) {
            continueWithExport = true;
            message = "Some checks failed, but were overridden.";
        } else {
            continueWithExport = false;
            message = "Some checks failed. No export file created.";
        }
        return new ContinueWithExportResult(continueWithExport, message);
    }

    private final PreflightStatusResult runPreflightChecks(Plan plan2, boolean waitForPreflights) {
        CountDownLatch latch = waitForPreflights ? new CountDownLatch(1) : new CountDownLatch(0);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String executionId = string;
        Ref.ObjectRef throwableError = new Ref.ObjectRef();
        PreflightService preflightService = this.preflightService;
        EnumSet<CheckType> enumSet = CheckType.Companion.getEmptyCheckTypeSet();
        EnumSet<CheckType> enumSet2 = CheckType.Companion.getEmptyCheckTypeSet();
        String string2 = plan2.getCloudId();
        List<String> list = plan2.getProjectKeys();
        UsersGroupsMigrationOption usersGroupsMigrationOption = plan2.getUsersGroupsMigrationOption();
        AppsMigrationOption appsMigrationOption = plan2.getAppsMigrationOption();
        ProjectDataMigrationMode projectDataMigrationMode = plan2.getProjectDataMigrationMode();
        MigrationType migrationType = plan2.getMigrationType();
        List<Long> list2 = plan2.getAdvancedRoadmapsPlanIds();
        Boolean bl = plan2.isCustomFieldsDeleted();
        SinglePathMode singlePathMode = SinglePathMode.LIFT_AND_SHIFT;
        String string3 = "" + '{' + plan2 + ".planName} - Export Only";
        LiftAndShiftMode liftAndShiftMode = LiftAndShiftMode.MANUAL_EXPORT;
        IssueFilters issueFilters = plan2.getIssueFilters();
        AttachmentFilters attachmentFilters = plan2.getAttachmentFilters();
        MigrationTag migrationTag = plan2.getMigrationTag();
        PreflightService.executeChecksForDraftPlan$default(preflightService, executionId, enumSet, enumSet2, string2, list, usersGroupsMigrationOption, appsMigrationOption, projectDataMigrationMode, migrationType, list2, bl, singlePathMode, string3, liftAndShiftMode, null, false, (Function1)new Function1<PreflightService.ExecutionResult, Unit>(latch){
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$latch = $latch;
                super(1);
            }

            public final void invoke(@NotNull PreflightService.ExecutionResult it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.$latch.countDown();
            }
        }, (Function1)new Function1<Throwable, Unit>(latch, (Ref.ObjectRef<Throwable>)throwableError){
            final /* synthetic */ CountDownLatch $latch;
            final /* synthetic */ Ref.ObjectRef<Throwable> $throwableError;
            {
                this.$latch = $latch;
                this.$throwableError = $throwableError;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$latch.countDown();
                this.$throwableError.element = it;
            }
        }, null, null, null, migrationTag, issueFilters, attachmentFilters, 0x180000, null);
        latch.await();
        CheckExecutionStatus preflightStatusList = this.preflightService.getStatus(executionId);
        this.preflightService.deletePreflightCheckResult(executionId);
        return new PreflightStatusResult((Throwable)throwableError.element, preflightStatusList);
    }

    private final Path generateExportFile(CloudSite cloudSite2, boolean isWithoutAttachments) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        URI uRI = URI.create("https://dummy.url");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return this.siteDataWorker.generateManualInterventionExportFile(new Task(string, new JiraSiteDataUpload(string2, uRI), cloudSite2), this.getExportFileName(), isWithoutAttachments);
    }

    private final String getExportFileName() {
        String string;
        if (this.migrationFeatures.getEnableSinglePathLZ4MCS()) {
            string = "site-backup-manual-" + System.currentTimeMillis();
        } else {
            String string2 = DataUtils.getZipFilename((String)("site-backup-manual-" + System.currentTimeMillis()));
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$ContinueWithExportResult;", "", "continueWithExport", "", "message", "", "(ZLjava/lang/String;)V", "getContinueWithExport", "()Z", "getMessage", "()Ljava/lang/String;", "jira-migration-plugin"})
    public static final class ContinueWithExportResult {
        private final boolean continueWithExport;
        @NotNull
        private final String message;

        public ContinueWithExportResult(boolean continueWithExport, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.continueWithExport = continueWithExport;
            this.message = message;
        }

        public final boolean getContinueWithExport() {
            return this.continueWithExport;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\t\u001a\u0004\u0018\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$ManualInterventionExportResult;", "", "message", "", "exportLocation", "failedChecks", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "errorMessage", "preflightStatusList", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "testMigrationWithoutAttachments", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;Z)V", "getErrorMessage", "()Ljava/lang/String;", "getExportLocation", "getFailedChecks", "()Ljava/util/Set;", "getMessage", "getPreflightStatusList", "()Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "getTestMigrationWithoutAttachments", "()Z", "jira-migration-plugin"})
    public static final class ManualInterventionExportResult {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final String message;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final String exportLocation;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final Set<CheckType> failedChecks;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final String errorMessage;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final CheckExecutionStatus preflightStatusList;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final boolean testMigrationWithoutAttachments;

        public ManualInterventionExportResult(@NotNull String message, @NotNull String exportLocation, @NotNull Set<? extends CheckType> failedChecks, @NotNull String errorMessage2, @Nullable CheckExecutionStatus preflightStatusList, boolean testMigrationWithoutAttachments) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)exportLocation, (String)"exportLocation");
            Intrinsics.checkNotNullParameter(failedChecks, (String)"failedChecks");
            Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
            this.message = message;
            this.exportLocation = exportLocation;
            this.failedChecks = failedChecks;
            this.errorMessage = errorMessage2;
            this.preflightStatusList = preflightStatusList;
            this.testMigrationWithoutAttachments = testMigrationWithoutAttachments;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getExportLocation() {
            return this.exportLocation;
        }

        @NotNull
        public final Set<CheckType> getFailedChecks() {
            return this.failedChecks;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Nullable
        public final CheckExecutionStatus getPreflightStatusList() {
            return this.preflightStatusList;
        }

        public final boolean getTestMigrationWithoutAttachments() {
            return this.testMigrationWithoutAttachments;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator$PreflightStatusResult;", "", "throwableError", "", "preflightStatusList", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "(Ljava/lang/Throwable;Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;)V", "getPreflightStatusList", "()Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "getThrowableError", "()Ljava/lang/Throwable;", "jira-migration-plugin"})
    public static final class PreflightStatusResult {
        @Nullable
        private final Throwable throwableError;
        @Nullable
        private final CheckExecutionStatus preflightStatusList;

        public PreflightStatusResult(@Nullable Throwable throwableError, @Nullable CheckExecutionStatus preflightStatusList) {
            this.throwableError = throwableError;
            this.preflightStatusList = preflightStatusList;
        }

        @Nullable
        public final Throwable getThrowableError() {
            return this.throwableError;
        }

        @Nullable
        public final CheckExecutionStatus getPreflightStatusList() {
            return this.preflightStatusList;
        }
    }
}

