/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.workers.site.ManualInterventionExportGenerator;
import com.atlassian.jira.migration.workers.site.ManualInterventionExportRequest;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="manual-intervention")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/site/ManualInterventionResource;", "", "manualInterventionExportGenerator", "Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportGenerator;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "exportManual", "Ljavax/ws/rs/core/Response;", "request", "Lcom/atlassian/jira/migration/workers/site/ManualInterventionExportRequest;", "jira-migration-plugin"})
public final class ManualInterventionResource {
    @NotNull
    private final ManualInterventionExportGenerator manualInterventionExportGenerator;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public ManualInterventionResource(@NotNull ManualInterventionExportGenerator manualInterventionExportGenerator, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)manualInterventionExportGenerator, (String)"manualInterventionExportGenerator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.manualInterventionExportGenerator = manualInterventionExportGenerator;
        this.migrationFeatures = migrationFeatures;
    }

    @POST
    @Path(value="/export/site")
    @NotNull
    public final Response exportManual(@NotNull ManualInterventionExportRequest request) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.migrationFeatures.getEnableSinglePathManualIntervention()) {
            String string = request.getPlanId();
            String string2 = request.getPlanName();
            Set set = request.getChecksToOverride();
            if (set == null) {
                set = CheckType.Companion.getEmptyCheckTypeSet();
            }
            Boolean bl = request.getSkipAllChecks();
            response2 = ResponseUtils.INSTANCE.ok(this.manualInterventionExportGenerator.exportManual(string, string2, set, true, bl != null ? bl : false));
        } else {
            response2 = ResponseUtils.INSTANCE.notFound();
        }
        return response2;
    }
}

