/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.FileMigrator;
import com.atlassian.jira.migration.workers.site.FileUploader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/site/MediaFileUploader;", "Lcom/atlassian/jira/migration/workers/site/FileUploader;", "fileMigrator", "Lcom/atlassian/jira/migration/workers/attachments/FileMigrator;", "(Lcom/atlassian/jira/migration/workers/attachments/FileMigrator;)V", "upload", "Lcom/atlassian/jira/migration/workers/site/FileUploader$Companion$FileUploadResult;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "exportPath", "Ljava/nio/file/Path;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMediaFileUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaFileUploader.kt\ncom/atlassian/jira/migration/workers/site/MediaFileUploader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,24:1\n1#2:25\n*E\n"})
public final class MediaFileUploader
implements FileUploader {
    @NotNull
    private final FileMigrator fileMigrator;

    @Inject
    public MediaFileUploader(@NotNull FileMigrator fileMigrator) {
        Intrinsics.checkNotNullParameter((Object)fileMigrator, (String)"fileMigrator");
        this.fileMigrator = fileMigrator;
    }

    @Override
    @NotNull
    public FileUploader.Companion.FileUploadResult upload(@NotNull Task task, @NotNull Path exportPath) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(exportPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "the provided path is not a regular file: " + exportPath;
            throw new IllegalArgumentException(string.toString());
        }
        File file2 = exportPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        Pair<String, Boolean> result2 = this.fileMigrator.process(task, file2);
        return new FileUploader.Companion.FileUploadResult(((Object)exportPath.getFileName()).toString(), (String)result2.getFirst(), (Boolean)result2.getSecond());
    }
}

