/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.TransferMigrationTask;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.attachments.AttachmentMigrator;
import com.atlassian.jira.migration.workers.attachments.AvatarMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaMigrator;
import com.atlassian.jira.migration.workers.attachments.V3MediaWorkProgressHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002,-BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "attachmentMigrator", "Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator;", "avatarMigrator", "Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator;Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "taskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "getTaskType", "()Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "process", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "Companion", "V3SiteAttachmentProcessor", "jira-migration-plugin"})
public final class V3SiteAttachmentWorker
implements Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final JiraEventDetectionService jiraEventDetectionService;
    @NotNull
    private final AttachmentMigrator attachmentMigrator;
    @NotNull
    private final AvatarMigrator avatarMigrator;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final String id;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final MigrationTaskType taskType;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    private static final Logger log = LoggerFactory.getLogger(V3SiteAttachmentWorker.class);

    @Inject
    public V3SiteAttachmentWorker(@NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull AttachmentMigrator attachmentMigrator, @NotNull AvatarMigrator avatarMigrator, @NotNull ProjectManager projectManager, @NotNull PlatformService platformService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)attachmentMigrator, (String)"attachmentMigrator");
        Intrinsics.checkNotNullParameter((Object)avatarMigrator, (String)"avatarMigrator");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.metricsEventService = metricsEventService;
        this.jiraEventDetectionService = jiraEventDetectionService;
        this.attachmentMigrator = attachmentMigrator;
        this.avatarMigrator = avatarMigrator;
        this.projectManager = projectManager;
        this.platformService = platformService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
        this.migrationFeatures = migrationFeatures;
        this.discoveryService = discoveryService;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.migrationProtocol = MigrationProtocol.V3;
        this.taskType = MigrationTaskType.JIRA_SITE_MEDIA_UPLOAD;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.SITE));
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    @NotNull
    public MigrationTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    public void process(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        new V3SiteAttachmentProcessor(this.metricsEventService, this.jiraEventDetectionService, this.projectManager, task, this.platformService, this.attachmentMigrator, this.avatarMigrator, this.migrationFinalStatusRepository, this.appDataPreloadStatusRepository, this.migrationFeatures, this.discoveryService).processAllAttachments();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010-\u001a\u00020&J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0007J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0006\u00105\u001a\u000202R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker$V3SiteAttachmentProcessor;", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "attachmentMigrator", "Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator;", "avatarMigrator", "Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator;Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "attachmentTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/TransferMigrationTask;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "heartBeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "mediaWorkProgressHandler", "Lcom/atlassian/jira/migration/workers/attachments/V3MediaWorkProgressHandler;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "totalDataSize", "", "getTotalDataSize", "()J", "totalDataSize$delegate", "Lkotlin/Lazy;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "accumualteProjectDataSize", "activeMigrators", "", "Lcom/atlassian/jira/migration/workers/attachments/MediaMigrator;", "process", "", "projectKey", "", "processAllAttachments", "Companion", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nV3SiteAttachmentWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3SiteAttachmentWorker.kt\ncom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker$V3SiteAttachmentProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1549#2:174\n1620#2,3:175\n2661#2,7:179\n1855#2,2:186\n1#3:178\n*S KotlinDebug\n*F\n+ 1 V3SiteAttachmentWorker.kt\ncom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker$V3SiteAttachmentProcessor\n*L\n103#1:174\n103#1:175,3\n109#1:179,7\n149#1:186,2\n*E\n"})
    public static final class V3SiteAttachmentProcessor
    extends OperationProcessor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MetricsEventService metricsEventService;
        @NotNull
        private final ProjectManager projectManager;
        @NotNull
        private final Task task;
        @NotNull
        private final AttachmentMigrator attachmentMigrator;
        @NotNull
        private final AvatarMigrator avatarMigrator;
        @NotNull
        private final DiscoveryService discoveryService;
        @NotNull
        private final TransferMigrationTask attachmentTask;
        @NotNull
        private final ContainerToken containerToken;
        @NotNull
        private final MigrationId migrationId;
        @NotNull
        private final TransferId transferId;
        @NotNull
        private final PlatformHeartbeater heartBeater;
        @NotNull
        private final PlatformProgressUpdater progressUpdater;
        @NotNull
        private final Lazy totalDataSize$delegate;
        @NotNull
        private final V3MediaWorkProgressHandler mediaWorkProgressHandler;
        @NotNull
        private static final Logger log;
        private static final int MB = 0x100000;
        @NotNull
        private static final String SUCCESS = "Success";
        @NotNull
        private static final String FAILED = "Failed";

        public V3SiteAttachmentProcessor(@NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull ProjectManager projectManager, @NotNull Task task, @NotNull PlatformService platformService, @NotNull AttachmentMigrator attachmentMigrator, @NotNull AvatarMigrator avatarMigrator, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull DiscoveryService discoveryService) {
            Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
            Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
            Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
            Intrinsics.checkNotNullParameter((Object)attachmentMigrator, (String)"attachmentMigrator");
            Intrinsics.checkNotNullParameter((Object)avatarMigrator, (String)"avatarMigrator");
            Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
            Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
            Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
            Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
            super(metricsEventService, jiraEventDetectionService);
            this.metricsEventService = metricsEventService;
            this.projectManager = projectManager;
            this.task = task;
            this.attachmentMigrator = attachmentMigrator;
            this.avatarMigrator = avatarMigrator;
            this.discoveryService = discoveryService;
            MigrationTask migrationTask = this.task.getMigrationTask();
            Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.TransferMigrationTask");
            this.attachmentTask = (TransferMigrationTask)migrationTask;
            this.containerToken = new ContainerToken(this.task.getCloudSite().getContainerToken());
            this.migrationId = new MigrationId(this.task.getMigrationId());
            this.transferId = new TransferId(this.attachmentTask.getTransferId());
            this.heartBeater = new PlatformHeartbeater(platformService, this.containerToken, this.attachmentTask.getHeartbeatUrl(), null, null, 24, null);
            this.progressUpdater = new PlatformProgressUpdater(platformService, this.migrationId, this.transferId, this.containerToken, null, null, 48, null);
            this.totalDataSize$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
                final /* synthetic */ V3SiteAttachmentProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Long invoke() {
                    return this.this$0.accumualteProjectDataSize();
                }
            }));
            this.mediaWorkProgressHandler = new V3MediaWorkProgressHandler(this.heartBeater, this.progressUpdater, this.getTotalDataSize(), migrationFinalStatusRepository, this.task, appDataPreloadStatusRepository, migrationFeatures, null, 128, null);
        }

        private final long getTotalDataSize() {
            Lazy lazy = this.totalDataSize$delegate;
            return ((Number)lazy.getValue()).longValue();
        }

        /*
         * WARNING - void declaration
         */
        public final long accumualteProjectDataSize() {
            long l;
            List list;
            List list2;
            void $this$mapTo$iv$iv;
            List list3 = this.projectManager.getProjects();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getProjects(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Project project = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.activeMigrators();
                long l2 = 0L;
                for (Object t : iterable2) {
                    void migrator;
                    void project2;
                    MediaMigrator mediaMigrator = (MediaMigrator)t;
                    long l3 = l2;
                    boolean bl2 = false;
                    String string = project2.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    long l4 = migrator.calculateTotalDataSize(this.task, string, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ V3SiteAttachmentProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            V3SiteAttachmentProcessor.access$getHeartBeater$p(this.this$0).sendHeartbeat();
                        }
                    }));
                    l2 = l3 + l4;
                }
                collection.add(l2);
            }
            List it = list2 = (List)destination$iv$iv;
            boolean bl3 = false;
            List list4 = list = !((Collection)it).isEmpty() ? list2 : null;
            if (list != null) {
                void $this$reduce$iv;
                Iterable bl3 = list;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void totalDataSizePerProject;
                    long item$iv$iv = ((Number)iterator$iv.next()).longValue();
                    long acc = ((Number)accumulator$iv).longValue();
                    boolean bl4 = false;
                    accumulator$iv = acc + totalDataSizePerProject;
                }
                l = ((Number)accumulator$iv).longValue();
            } else {
                l = 0L;
            }
            return l;
        }

        public final void processAllAttachments() {
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            try {
                String operationKeyPrefix = "attach-" + this.task.getMigrationId() + "-site-" + UUID.randomUUID();
                OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.SITE_ATTACHMENT_UPLOAD, operationKeyPrefix + "-upload", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, plan2){
                    final /* synthetic */ V3SiteAttachmentProcessor this$0;
                    final /* synthetic */ Plan $plan;
                    {
                        this.this$0 = $receiver;
                        this.$plan = $plan;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final OperationProcessor.OperationOutcome invoke() {
                        void $this$forEach$iv;
                        List list = V3SiteAttachmentProcessor.access$getProjectManager$p(this.this$0).getProjects();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
                        Iterable iterable = list;
                        V3SiteAttachmentProcessor v3SiteAttachmentProcessor = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Project it = (Project)element$iv;
                            boolean bl = false;
                            String string = it.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                            V3SiteAttachmentProcessor.access$process(v3SiteAttachmentProcessor, string);
                        }
                        V3SiteAttachmentProcessor.access$getMediaWorkProgressHandler$p(this.this$0).sendFinishedStatusUpdate(this.$plan.getProjectDataMigrationMode());
                        return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(V3SiteAttachmentProcessor.access$getMediaWorkProgressHandler$p(this.this$0).getSuccessfullyMigratedBytes(), 0x100000));
                    }
                }, 4, null);
                MetricsEventService.sendEventForTask$default(this.metricsEventService, this.task.getMigrationTask().getMigrationTaskType(), SUCCESS, 0.0, 4, null);
            }
            catch (Exception ex) {
                log.warn(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": error in media upload task during bulk migration", (Throwable)ex);
                MetricsEventService.sendEventForTask$default(this.metricsEventService, this.task.getMigrationTask().getMigrationTaskType(), FAILED, 0.0, 4, null);
                this.mediaWorkProgressHandler.sendFailedStatusUpdate(ex);
            }
        }

        private final void process(String projectKey) {
            log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": uploading media for project key " + projectKey + " [Bulk migration]");
            Iterable $this$forEach$iv = this.activeMigrators();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaMigrator migrator = (MediaMigrator)element$iv;
                boolean bl = false;
                MediaMigrator.DefaultImpls.process$default(migrator, this.task, projectKey, this.mediaWorkProgressHandler.getHandleProgress(), null, 8, null);
            }
            log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": uploading media for project key " + projectKey + " complete [Bulk migration]");
        }

        @VisibleForTesting
        @NotNull
        public final List<MediaMigrator> activeMigrators() {
            Object[] objectArray = new MediaMigrator[]{this.attachmentMigrator, this.avatarMigrator};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public static final /* synthetic */ ProjectManager access$getProjectManager$p(V3SiteAttachmentProcessor $this) {
            return $this.projectManager;
        }

        public static final /* synthetic */ V3MediaWorkProgressHandler access$getMediaWorkProgressHandler$p(V3SiteAttachmentProcessor $this) {
            return $this.mediaWorkProgressHandler;
        }

        public static final /* synthetic */ void access$process(V3SiteAttachmentProcessor $this, String projectKey) {
            $this.process(projectKey);
        }

        public static final /* synthetic */ PlatformHeartbeater access$getHeartBeater$p(V3SiteAttachmentProcessor $this) {
            return $this.heartBeater;
        }

        static {
            Logger logger2 = LoggerFactory.getLogger(V3SiteAttachmentProcessor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            log = logger2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteAttachmentWorker$V3SiteAttachmentProcessor$Companion;", "", "()V", "FAILED", "", "MB", "", "SUCCESS", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Logger getLog() {
                return log;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

