/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.EnrichSiteBackupCompleted;
import com.atlassian.jira.migration.events.EnrichSiteBackupFailed;
import com.atlassian.jira.migration.events.EnrichSiteBackupStarted;
import com.atlassian.jira.migration.events.GenerateCsvLinkingCompleted;
import com.atlassian.jira.migration.events.GenerateCsvLinkingFailed;
import com.atlassian.jira.migration.events.GenerateCsvLinkingStarted;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationPhaseEvent;
import com.atlassian.jira.migration.events.SiteBackupCompleted;
import com.atlassian.jira.migration.events.SiteBackupFailed;
import com.atlassian.jira.migration.events.SiteBackupStarted;
import com.atlassian.jira.migration.events.UploadEnrichedSiteBackupCompleted;
import com.atlassian.jira.migration.events.UploadEnrichedSiteBackupFailed;
import com.atlassian.jira.migration.events.UploadEnrichedSiteBackupStarted;
import com.atlassian.jira.migration.export.site.SiteExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.orchestratorclient.tasks.JiraSiteDataUpload;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.liftandshift.BulkImportRequestBuilder;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.site.FileUploader;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateCsvOperationResult;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateSiteDataCsvOperation;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateSiteDataCsvOperationFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u0089\u00012\u00020\u0001:\u0002\u0089\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010i\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020X0j2\u0006\u0010l\u001a\u00020\u000bH\u0002J\u0016\u0010m\u001a\u00020k2\u0006\u0010n\u001a\u00020k2\u0006\u0010l\u001a\u00020\u000bJ\b\u0010o\u001a\u00020XH\u0002J$\u0010p\u001a\u00020k2\u0006\u0010n\u001a\u00020k2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020k\u0012\u0004\u0012\u00020X0jH\u0007J\u0006\u0010r\u001a\u00020sJ&\u0010t\u001a\u00020s2\u0006\u0010u\u001a\u00020v2\u0014\u0010w\u001a\u0010\u0012\u0004\u0012\u00020X\u0012\u0006\u0012\u0004\u0018\u00010x0jH\u0002J\u001c\u0010y\u001a\u00020s2\u0006\u0010u\u001a\u00020v2\n\b\u0002\u0010z\u001a\u0004\u0018\u00010XH\u0002J\u0010\u0010{\u001a\u00020s2\u0006\u0010u\u001a\u00020vH\u0002J/\u0010|\u001a\u00020s2\b\u0010}\u001a\u0004\u0018\u00010X2\b\u0010~\u001a\u0004\u0018\u00010X2\u0006\u0010\u007f\u001a\u00020\u000b2\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010XJ\u0007\u0010\u0081\u0001\u001a\u00020sJ\u001c\u0010\u0082\u0001\u001a\u00030\u0083\u00012\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0083\u0001H\u0002\u00a2\u0006\u0003\u0010\u0085\u0001J\u0013\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020kH\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0019\u0010D\u001a\n F*\u0004\u0018\u00010E0E\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u00020JX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020PX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010W\u001a\u00020X\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010ZR\u0011\u0010[\u001a\u00020\\\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010^R\u001a\u0010_\u001a\u00020`X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008a\u0001"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteDataProcessor;", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "exportOnlyMode", "", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Z)V", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Ljava/util/concurrent/ScheduledExecutorService;Z)V", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "getDiscoveryService", "()Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "setDiscoveryService", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "getExportOnlyMode", "()Z", "exportService", "Lcom/atlassian/jira/migration/export/site/SiteExportService;", "getExportService", "()Lcom/atlassian/jira/migration/export/site/SiteExportService;", "setExportService", "(Lcom/atlassian/jira/migration/export/site/SiteExportService;)V", "fileUploader", "Lcom/atlassian/jira/migration/workers/site/FileUploader;", "getFileUploader", "()Lcom/atlassian/jira/migration/workers/site/FileUploader;", "setFileUploader", "(Lcom/atlassian/jira/migration/workers/site/FileUploader;)V", "generateCsvOperationFactory", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperationFactory;", "getGenerateCsvOperationFactory", "()Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperationFactory;", "setGenerateCsvOperationFactory", "(Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperationFactory;)V", "getHeartbeatScheduler", "()Ljava/util/concurrent/ScheduledExecutorService;", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "getHeartbeater", "()Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "getIssueManager", "()Lcom/atlassian/jira/issue/IssueManager;", "setIssueManager", "(Lcom/atlassian/jira/issue/IssueManager;)V", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "getJiraAuthenticationContext", "()Lcom/atlassian/jira/security/JiraAuthenticationContext;", "setJiraAuthenticationContext", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;)V", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "getLocalFileDataOutput", "()Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "setLocalFileDataOutput", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "getMigrationEventBus", "()Lcom/atlassian/jira/migration/events/MigrationEventBus;", "setMigrationEventBus", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "setMigrationFeatures", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "operationKeyPrefix", "", "getOperationKeyPrefix", "()Ljava/lang/String;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "getProgressUpdater", "()Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "getProjectManager", "()Lcom/atlassian/jira/project/ProjectManager;", "setProjectManager", "(Lcom/atlassian/jira/project/ProjectManager;)V", "transferId", "Lcom/atlassian/migration/api/TransferId;", "transferTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/JiraSiteDataUpload;", "generateCsvFiles", "", "Ljava/nio/file/Path;", "isWithoutAttachments", "generateEnrichedBackup", "targetExportPath", "getCompressionTag", "initiateSiteBackup", "csvFiles", "process", "", "processComplete", "phase", "Lcom/atlassian/jira/migration/workers/site/V3SiteDataProcessor$Companion$SiteDataWorkerPhase;", "data", "", "processFail", "failedReason", "processStart", "sendFinalStatus", "fileId", "filename", "success", "message", "sendHeartbeat", "toReportSize", "", "size", "(Ljava/lang/Long;)J", "uploadBackup", "Lcom/atlassian/jira/migration/workers/site/FileUploader$Companion$FileUploadResult;", "pathToFile", "Companion", "jira-migration-plugin"})
public final class V3SiteDataProcessor
extends OperationProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Task task;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    private final boolean exportOnlyMode;
    public MigrationEventBus migrationEventBus;
    public LocalFileDataOutput localFileDataOutput;
    public IssueManager issueManager;
    public ProjectManager projectManager;
    public JiraAuthenticationContext jiraAuthenticationContext;
    public SiteExportService exportService;
    public FileUploader fileUploader;
    public MigrationFeatures migrationFeatures;
    public DiscoveryService discoveryService;
    public GenerateSiteDataCsvOperationFactory generateCsvOperationFactory;
    private final Logger log;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final JiraSiteDataUpload transferTask;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final String operationKeyPrefix;
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILED = "Failed";
    private static final int MB = 0x100000;
    @NotNull
    public static final String MANUAL_INTERVENTION_NOT_SUPPORTED_MSG = "Manual intervention mode is specified in plan but feature flag is not enabled.";

    public V3SiteDataProcessor(@NotNull Task task, @NotNull PlatformService platformService, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull ScheduledExecutorService heartbeatScheduler, boolean exportOnlyMode) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        super(metricsEventService, jiraEventDetectionService);
        this.task = task;
        this.metricsEventService = metricsEventService;
        this.heartbeatScheduler = heartbeatScheduler;
        this.exportOnlyMode = exportOnlyMode;
        this.log = LoggerFactory.getLogger(V3SiteDataProcessor.class);
        this.migrationId = new MigrationId(this.task.getMigrationId());
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.JiraSiteDataUpload");
        this.transferTask = (JiraSiteDataUpload)migrationTask;
        this.transferId = new TransferId(this.transferTask.getTransferId());
        this.containerToken = new ContainerToken(this.task.getCloudSite().getContainerToken());
        this.operationKeyPrefix = "site-upload-" + this.task.getMigrationId() + '-' + UUID.randomUUID();
        this.heartbeater = new PlatformHeartbeater(platformService, this.containerToken, this.transferTask.getHeartbeatUrl(), null, null, 24, null);
        this.progressUpdater = new PlatformProgressUpdater(platformService, this.migrationId, this.transferId, this.containerToken, null, null, 48, null);
    }

    public /* synthetic */ V3SiteDataProcessor(Task task, PlatformService platformService, MetricsEventService metricsEventService, JiraEventDetectionService jiraEventDetectionService, ScheduledExecutorService scheduledExecutorService, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(task, platformService, metricsEventService, jiraEventDetectionService, scheduledExecutorService, bl);
    }

    @NotNull
    public final ScheduledExecutorService getHeartbeatScheduler() {
        return this.heartbeatScheduler;
    }

    public final boolean getExportOnlyMode() {
        return this.exportOnlyMode;
    }

    @NotNull
    public final MigrationEventBus getMigrationEventBus() {
        MigrationEventBus migrationEventBus = this.migrationEventBus;
        if (migrationEventBus != null) {
            return migrationEventBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"migrationEventBus");
        return null;
    }

    public final void setMigrationEventBus(@NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"<set-?>");
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final LocalFileDataOutput getLocalFileDataOutput() {
        LocalFileDataOutput localFileDataOutput = this.localFileDataOutput;
        if (localFileDataOutput != null) {
            return localFileDataOutput;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"localFileDataOutput");
        return null;
    }

    public final void setLocalFileDataOutput(@NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"<set-?>");
        this.localFileDataOutput = localFileDataOutput;
    }

    @NotNull
    public final IssueManager getIssueManager() {
        IssueManager issueManager = this.issueManager;
        if (issueManager != null) {
            return issueManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"issueManager");
        return null;
    }

    public final void setIssueManager(@NotNull IssueManager issueManager) {
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"<set-?>");
        this.issueManager = issueManager;
    }

    @NotNull
    public final ProjectManager getProjectManager() {
        ProjectManager projectManager = this.projectManager;
        if (projectManager != null) {
            return projectManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"projectManager");
        return null;
    }

    public final void setProjectManager(@NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"<set-?>");
        this.projectManager = projectManager;
    }

    @NotNull
    public final JiraAuthenticationContext getJiraAuthenticationContext() {
        JiraAuthenticationContext jiraAuthenticationContext = this.jiraAuthenticationContext;
        if (jiraAuthenticationContext != null) {
            return jiraAuthenticationContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jiraAuthenticationContext");
        return null;
    }

    public final void setJiraAuthenticationContext(@NotNull JiraAuthenticationContext jiraAuthenticationContext) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"<set-?>");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @NotNull
    public final SiteExportService getExportService() {
        SiteExportService siteExportService = this.exportService;
        if (siteExportService != null) {
            return siteExportService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"exportService");
        return null;
    }

    public final void setExportService(@NotNull SiteExportService siteExportService) {
        Intrinsics.checkNotNullParameter((Object)siteExportService, (String)"<set-?>");
        this.exportService = siteExportService;
    }

    @NotNull
    public final FileUploader getFileUploader() {
        FileUploader fileUploader = this.fileUploader;
        if (fileUploader != null) {
            return fileUploader;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileUploader");
        return null;
    }

    public final void setFileUploader(@NotNull FileUploader fileUploader) {
        Intrinsics.checkNotNullParameter((Object)fileUploader, (String)"<set-?>");
        this.fileUploader = fileUploader;
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        MigrationFeatures migrationFeatures = this.migrationFeatures;
        if (migrationFeatures != null) {
            return migrationFeatures;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"migrationFeatures");
        return null;
    }

    public final void setMigrationFeatures(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"<set-?>");
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final DiscoveryService getDiscoveryService() {
        DiscoveryService discoveryService = this.discoveryService;
        if (discoveryService != null) {
            return discoveryService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"discoveryService");
        return null;
    }

    public final void setDiscoveryService(@NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"<set-?>");
        this.discoveryService = discoveryService;
    }

    @NotNull
    public final GenerateSiteDataCsvOperationFactory getGenerateCsvOperationFactory() {
        GenerateSiteDataCsvOperationFactory generateSiteDataCsvOperationFactory = this.generateCsvOperationFactory;
        if (generateSiteDataCsvOperationFactory != null) {
            return generateSiteDataCsvOperationFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"generateCsvOperationFactory");
        return null;
    }

    public final void setGenerateCsvOperationFactory(@NotNull GenerateSiteDataCsvOperationFactory generateSiteDataCsvOperationFactory) {
        Intrinsics.checkNotNullParameter((Object)generateSiteDataCsvOperationFactory, (String)"<set-?>");
        this.generateCsvOperationFactory = generateSiteDataCsvOperationFactory;
    }

    public final Logger getLog() {
        return this.log;
    }

    public V3SiteDataProcessor(@NotNull Task task, @NotNull PlatformService platformService, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, boolean exportOnlyMode) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("V3SiteDataProcessor"));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this(task, platformService, metricsEventService, jiraEventDetectionService, scheduledExecutorService, exportOnlyMode);
    }

    @NotNull
    public final String getOperationKeyPrefix() {
        return this.operationKeyPrefix;
    }

    @NotNull
    public final PlatformHeartbeater getHeartbeater() {
        return this.heartbeater;
    }

    @NotNull
    public final PlatformProgressUpdater getProgressUpdater() {
        return this.progressUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process() {
        this.heartbeatScheduler.scheduleAtFixedRate(() -> V3SiteDataProcessor.process$lambda$0(this), 0L, this.heartbeater.getReportingPeriod().getSeconds() + 1L, TimeUnit.SECONDS);
        boolean status = false;
        Exception exception = null;
        String fileId = null;
        Path exportFilePath = null;
        FileUploader.Companion.FileUploadResult uploadResult = new FileUploader.Companion.FileUploadResult(null, null, false, 7, null);
        try {
            Path path;
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            if (plan2.isManualImport()) {
                if (!this.getMigrationFeatures().getEnableSinglePathManualIntervention()) {
                    this.log.error(MANUAL_INTERVENTION_NOT_SUPPORTED_MSG);
                    throw new IllegalStateException(MANUAL_INTERVENTION_NOT_SUPPORTED_MSG.toString());
                }
                if (plan2.getManualImportFile() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.log.info("Using manual intervention mode with file '" + plan2.getManualImportFile() + "'.");
                path = Paths.get(plan2.getManualImportFile(), new String[0]);
            } else {
                String fileName = this.getMigrationFeatures().getEnableSinglePathLZ4MCS() ? "site-backup-" + System.currentTimeMillis() : "site-backup-" + System.currentTimeMillis() + ".zip";
                String[] stringArray = new String[]{fileName};
                Path targetExportPath = Paths.get(((Object)this.getLocalFileDataOutput().exportDirectory()).toString(), stringArray);
                boolean isWithoutAttachments = MigrationModeUtil.INSTANCE.isWithoutAttachments(plan2.isTestMigrationWithoutAttachments(), this.getMigrationFeatures());
                Intrinsics.checkNotNull((Object)targetExportPath);
                path = this.generateEnrichedBackup(targetExportPath, isWithoutAttachments);
            }
            exportFilePath = path;
            boolean uploadSuccess = false;
            if (exportFilePath != null) {
                uploadResult = this.uploadBackup(exportFilePath);
                fileId = uploadResult.getFileId();
                uploadSuccess = uploadResult.getSuccess();
                this.log.info("fileId = " + fileId);
            }
            status = exportFilePath != null && uploadSuccess;
            this.sendFinalStatus(uploadResult.getFileId(), uploadResult.getFilename(), status, null);
        }
        catch (Exception e) {
            try {
                this.log.error(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": Error processing lift and shift migration for site", (Throwable)e);
                exception = e;
                Exception exception2 = exception;
                this.sendFinalStatus(uploadResult.getFileId(), uploadResult.getFilename(), status, exception2 == null ? null : ProgressItem.Companion.throwableToDetailsMessage(exception2));
            }
            catch (Throwable throwable) {
                this.sendFinalStatus(uploadResult.getFileId(), uploadResult.getFilename(), status, null);
                this.heartbeatScheduler.shutdown();
                throw throwable;
            }
            this.heartbeatScheduler.shutdown();
        }
        this.heartbeatScheduler.shutdown();
        this.sendHeartbeat();
    }

    @NotNull
    public final Path generateEnrichedBackup(@NotNull Path targetExportPath, boolean isWithoutAttachments) {
        Intrinsics.checkNotNullParameter((Object)targetExportPath, (String)"targetExportPath");
        Map<Path, String> csvFiles = this.generateCsvFiles(isWithoutAttachments);
        return this.initiateSiteBackup(targetExportPath, csvFiles);
    }

    private final Map<Path, String> generateCsvFiles(boolean isWithoutAttachments) {
        try {
            this.processStart(Companion.SiteDataWorkerPhase.CSV_LINKING);
            Map filePathMap = new LinkedHashMap();
            Map analyticResult = new LinkedHashMap();
            List<GenerateSiteDataCsvOperation> csvOperations = this.getGenerateCsvOperationFactory().create(!isWithoutAttachments, !isWithoutAttachments);
            for (GenerateSiteDataCsvOperation csvOperation : csvOperations) {
                this.log.info("running csv generation: " + csvOperation.getClass().getName());
                GenerateCsvOperationResult result2 = csvOperation.generate(this.operationKeyPrefix, this.task, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                    public final void invoke() {
                        ((V3SiteDataProcessor)this.receiver).sendHeartbeat();
                    }
                }));
                if (result2 == null) continue;
                filePathMap.put(result2.getFilePath(), result2.getFilename());
                analyticResult.putAll(result2.getAnalyticResult());
            }
            this.processComplete(Companion.SiteDataWorkerPhase.CSV_LINKING, analyticResult);
            return filePathMap;
        }
        catch (Exception ex) {
            this.processFail(Companion.SiteDataWorkerPhase.CSV_LINKING, ex.getMessage());
            throw ex;
        }
    }

    @VisibleForTesting
    @NotNull
    public final Path initiateSiteBackup(@NotNull Path targetExportPath, @NotNull Map<Path, String> csvFiles) {
        Intrinsics.checkNotNullParameter((Object)targetExportPath, (String)"targetExportPath");
        Intrinsics.checkNotNullParameter(csvFiles, (String)"csvFiles");
        this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": Exporting site backup for lift and shift migration");
        this.processStart(Companion.SiteDataWorkerPhase.SITE_BACKUP);
        Ref.ObjectRef exportedFileSize = new Ref.ObjectRef();
        this.runTimedOperation(MetricsEventService.OperationType.SITE_EXPORT_DURATION, this.operationKeyPrefix + "-export-site", MapsKt.mapOf((Pair)TuplesKt.to((Object)"export_compression", (Object)this.getCompressionTag())), (Function0<OperationProcessor.OperationOutcome>)((Function0)new Function0<OperationProcessor.OperationOutcome>(this, targetExportPath, csvFiles, (Ref.ObjectRef<Long>)exportedFileSize){
            final /* synthetic */ V3SiteDataProcessor this$0;
            final /* synthetic */ Path $targetExportPath;
            final /* synthetic */ Map<Path, String> $csvFiles;
            final /* synthetic */ Ref.ObjectRef<Long> $exportedFileSize;
            {
                this.this$0 = $receiver;
                this.$targetExportPath = $targetExportPath;
                this.$csvFiles = $csvFiles;
                this.$exportedFileSize = $exportedFileSize;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                this.this$0.getLog().info("=============> type of exportService: " + this.this$0.getExportService().getClass().getName());
                try {
                    this.this$0.getExportService().exportWithAdditionalFiles(this.this$0.getJiraAuthenticationContext().getLoggedInUser(), ((Object)this.$targetExportPath).toString(), this.$csvFiles, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ V3SiteDataProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.sendHeartbeat();
                        }
                    }));
                    this.$exportedFileSize.element = FileUtils.sizeOf((File)this.$targetExportPath.toFile());
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"fileSize", (Object)this.$exportedFileSize.element), TuplesKt.to((Object)"projectCount", (Object)this.this$0.getProjectManager().getProjectCount()), TuplesKt.to((Object)"issueCount", (Object)this.this$0.getIssueManager().getIssueCount())};
                    V3SiteDataProcessor.access$processComplete(this.this$0, Companion.SiteDataWorkerPhase.SITE_BACKUP, MapsKt.mapOf((Pair[])pairArray));
                }
                catch (Exception e) {
                    V3SiteDataProcessor.access$processFail(this.this$0, Companion.SiteDataWorkerPhase.SITE_BACKUP, e.getMessage());
                    throw e;
                }
                this.this$0.getLog().info(V3SiteDataProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + V3SiteDataProcessor.access$getTask$p(this.this$0).getTaskId() + ": Exported site backup: " + this.$targetExportPath);
                return new OperationProcessor.OperationOutcome(V3SiteDataProcessor.access$toReportSize(this.this$0, (Long)this.$exportedFileSize.element));
            }
        }));
        return targetExportPath;
    }

    @VisibleForTesting
    @NotNull
    public final FileUploader.Companion.FileUploadResult uploadBackup(@NotNull Path pathToFile) {
        Intrinsics.checkNotNullParameter((Object)pathToFile, (String)"pathToFile");
        try {
            this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": Uploading site backup for lift and shift migration");
            this.processStart(Companion.SiteDataWorkerPhase.UPLOAD_BACKUP);
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            result2.element = new FileUploader.Companion.FileUploadResult(null, null, false, 7, null);
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            long fileSize = FileUtils.sizeOf((File)pathToFile.toFile());
            String string = this.operationKeyPrefix + "-upload-backup";
            Pair[] pairArray = new Pair[2];
            Object object = plan2.getLiftAndShiftMode();
            if (object == null || (object = object.name()) == null) {
                object = "undefined";
            }
            pairArray[0] = TuplesKt.to((Object)"data_generation_type", (Object)object);
            pairArray[1] = TuplesKt.to((Object)"export_compression", (Object)this.getCompressionTag());
            this.runTimedOperation(MetricsEventService.OperationType.SITE_UPLOAD_DURATION, string, MapsKt.mapOf((Pair[])pairArray), (Function0<OperationProcessor.OperationOutcome>)((Function0)new Function0<OperationProcessor.OperationOutcome>((Ref.ObjectRef<FileUploader.Companion.FileUploadResult>)result2, this, pathToFile, fileSize){
                final /* synthetic */ Ref.ObjectRef<FileUploader.Companion.FileUploadResult> $result;
                final /* synthetic */ V3SiteDataProcessor this$0;
                final /* synthetic */ Path $pathToFile;
                final /* synthetic */ long $fileSize;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    this.$pathToFile = $pathToFile;
                    this.$fileSize = $fileSize;
                    super(0);
                }

                @NotNull
                public final OperationProcessor.OperationOutcome invoke() {
                    this.$result.element = this.this$0.getFileUploader().upload(V3SiteDataProcessor.access$getTask$p(this.this$0), this.$pathToFile);
                    this.this$0.getLog().info(V3SiteDataProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + V3SiteDataProcessor.access$getTask$p(this.this$0).getTaskId() + ": Uploaded site backup");
                    return new OperationProcessor.OperationOutcome(V3SiteDataProcessor.access$toReportSize(this.this$0, this.$fileSize));
                }
            }));
            if (!((FileUploader.Companion.FileUploadResult)result2.element).getSuccess()) {
                V3SiteDataProcessor.processFail$default(this, Companion.SiteDataWorkerPhase.UPLOAD_BACKUP, null, 2, null);
            } else {
                this.processComplete(Companion.SiteDataWorkerPhase.UPLOAD_BACKUP, MapsKt.mapOf((Pair)TuplesKt.to((Object)"fileSize", (Object)fileSize)));
            }
            return (FileUploader.Companion.FileUploadResult)result2.element;
        }
        catch (Exception ex) {
            this.processFail(Companion.SiteDataWorkerPhase.UPLOAD_BACKUP, ex.getMessage());
            throw ex;
        }
    }

    public final void sendHeartbeat() {
        if (!this.exportOnlyMode) {
            this.heartbeater.sendHeartbeat();
        }
    }

    public final void sendFinalStatus(@Nullable String fileId, @Nullable String filename, boolean success, @Nullable String message) {
        MetricsEventService.sendEventForTask$default(this.metricsEventService, this.task.getMigrationTask().getMigrationTaskType(), success ? SUCCESS : FAILED, 0.0, 4, null);
        this.progressUpdater.sendFinalStatus(success ? TransferStatus.SUCCESS : TransferStatus.FAILED, new BulkImportRequestBuilder(filename, fileId).build(), message);
    }

    public static /* synthetic */ void sendFinalStatus$default(V3SiteDataProcessor v3SiteDataProcessor, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        v3SiteDataProcessor.sendFinalStatus(string, string2, bl, string3);
    }

    private final void processStart(Companion.SiteDataWorkerPhase phase) {
        if (!this.exportOnlyMode) {
            MigrationPhaseEvent migrationPhaseEvent;
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                case 1: {
                    migrationPhaseEvent = new GenerateCsvLinkingStarted(this.task.getCloudId(), this.task.getMigrationId());
                    break;
                }
                case 2: {
                    migrationPhaseEvent = new SiteBackupStarted(this.task.getCloudId(), this.task.getMigrationId());
                    break;
                }
                case 3: {
                    migrationPhaseEvent = new EnrichSiteBackupStarted(this.task.getCloudId(), this.task.getMigrationId());
                    break;
                }
                case 4: {
                    migrationPhaseEvent = new UploadEnrichedSiteBackupStarted(this.task.getCloudId(), this.task.getMigrationId(), plan2.getLiftAndShiftMode());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MigrationPhaseEvent event = migrationPhaseEvent;
            this.getMigrationEventBus().post(event);
        }
    }

    private final void processComplete(Companion.SiteDataWorkerPhase phase, Map<String, ? extends Object> data2) {
        if (!this.exportOnlyMode) {
            MigrationPhaseEvent migrationPhaseEvent;
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                case 1: {
                    migrationPhaseEvent = new GenerateCsvLinkingCompleted(this.task.getCloudId(), this.task.getMigrationId(), ConvertorHelpers.Companion.asLongOrNull(data2.get("attachmentCsvSize")), ConvertorHelpers.Companion.asLongOrNull(data2.get("attachmentNumber")), ConvertorHelpers.Companion.asLongOrNull(data2.get("avatarCsvSize")), ConvertorHelpers.Companion.asLongOrNull(data2.get("avatarNumber")), ConvertorHelpers.Companion.asLongOrNull(data2.get("invalidUsers")), ConvertorHelpers.Companion.asLongOrNull(data2.get("invalidCustomers")), ConvertorHelpers.Companion.asLongOrNull(data2.get("duplicatedUsers")), ConvertorHelpers.Companion.asLongOrNull(data2.get("duplicatedCustomers")), ConvertorHelpers.Companion.asLongOrNull(data2.get("appWorkflowRules")));
                    break;
                }
                case 2: {
                    migrationPhaseEvent = new SiteBackupCompleted(this.task.getCloudId(), this.task.getMigrationId(), ConvertorHelpers.Companion.asLongOrNull(data2.get("fileSize")), ConvertorHelpers.Companion.asLongOrNull(data2.get("projectCount")), ConvertorHelpers.Companion.asLongOrNull(data2.get("issueCount")));
                    break;
                }
                case 3: {
                    migrationPhaseEvent = new EnrichSiteBackupCompleted(this.task.getCloudId(), this.task.getMigrationId(), ConvertorHelpers.Companion.asLongOrNull(data2.get("fileSize")));
                    break;
                }
                case 4: {
                    migrationPhaseEvent = new UploadEnrichedSiteBackupCompleted(this.task.getCloudId(), this.task.getMigrationId(), plan2.getLiftAndShiftMode(), ConvertorHelpers.Companion.asLongOrNull(data2.get("fileSize")));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MigrationPhaseEvent event = migrationPhaseEvent;
            this.getMigrationEventBus().post(event);
        }
    }

    private final void processFail(Companion.SiteDataWorkerPhase phase, String failedReason) {
        if (!this.exportOnlyMode) {
            MigrationPhaseEvent migrationPhaseEvent;
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                case 1: {
                    migrationPhaseEvent = new GenerateCsvLinkingFailed(this.task.getCloudId(), this.task.getMigrationId(), failedReason);
                    break;
                }
                case 2: {
                    migrationPhaseEvent = new SiteBackupFailed(this.task.getCloudId(), this.task.getMigrationId(), failedReason);
                    break;
                }
                case 3: {
                    migrationPhaseEvent = new EnrichSiteBackupFailed(this.task.getCloudId(), this.task.getMigrationId(), failedReason);
                    break;
                }
                case 4: {
                    migrationPhaseEvent = new UploadEnrichedSiteBackupFailed(this.task.getCloudId(), this.task.getMigrationId(), plan2.getLiftAndShiftMode(), failedReason);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MigrationPhaseEvent event = migrationPhaseEvent;
            this.getMigrationEventBus().post(event);
        }
    }

    static /* synthetic */ void processFail$default(V3SiteDataProcessor v3SiteDataProcessor, Companion.SiteDataWorkerPhase siteDataWorkerPhase, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        v3SiteDataProcessor.processFail(siteDataWorkerPhase, string);
    }

    private final long toReportSize(Long size) {
        return LongExtensionsKt.safeDivide(size, 0x100000);
    }

    private final String getCompressionTag() {
        return this.getMigrationFeatures().getEnableSinglePathLZ4MCS() ? "LZ4" : "ZIP";
    }

    private static final void process$lambda$0(V3SiteDataProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sendHeartbeat();
    }

    public static final /* synthetic */ void access$processComplete(V3SiteDataProcessor $this, Companion.SiteDataWorkerPhase phase, Map data2) {
        $this.processComplete(phase, data2);
    }

    public static final /* synthetic */ void access$processFail(V3SiteDataProcessor $this, Companion.SiteDataWorkerPhase phase, String failedReason) {
        $this.processFail(phase, failedReason);
    }

    public static final /* synthetic */ Task access$getTask$p(V3SiteDataProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ long access$toReportSize(V3SiteDataProcessor $this, Long size) {
        return $this.toReportSize(size);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteDataProcessor$Companion;", "", "()V", "FAILED", "", "MANUAL_INTERVENTION_NOT_SUPPORTED_MSG", "getMANUAL_INTERVENTION_NOT_SUPPORTED_MSG$annotations", "MB", "", "SUCCESS", "SiteDataWorkerPhase", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMANUAL_INTERVENTION_NOT_SUPPORTED_MSG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteDataProcessor$Companion$SiteDataWorkerPhase;", "", "(Ljava/lang/String;I)V", "CSV_LINKING", "SITE_BACKUP", "ENRICH_SITE_BACKUP", "UPLOAD_BACKUP", "jira-migration-plugin"})
        public static final class SiteDataWorkerPhase
        extends Enum<SiteDataWorkerPhase> {
            public static final /* enum */ SiteDataWorkerPhase CSV_LINKING = new SiteDataWorkerPhase();
            public static final /* enum */ SiteDataWorkerPhase SITE_BACKUP = new SiteDataWorkerPhase();
            public static final /* enum */ SiteDataWorkerPhase ENRICH_SITE_BACKUP = new SiteDataWorkerPhase();
            public static final /* enum */ SiteDataWorkerPhase UPLOAD_BACKUP = new SiteDataWorkerPhase();
            private static final /* synthetic */ SiteDataWorkerPhase[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static SiteDataWorkerPhase[] values() {
                return (SiteDataWorkerPhase[])$VALUES.clone();
            }

            public static SiteDataWorkerPhase valueOf(String value) {
                return Enum.valueOf(SiteDataWorkerPhase.class, value);
            }

            @NotNull
            public static EnumEntries<SiteDataWorkerPhase> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = siteDataWorkerPhaseArray = new SiteDataWorkerPhase[]{SiteDataWorkerPhase.CSV_LINKING, SiteDataWorkerPhase.SITE_BACKUP, SiteDataWorkerPhase.ENRICH_SITE_BACKUP, SiteDataWorkerPhase.UPLOAD_BACKUP};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.SiteDataWorkerPhase.values().length];
            try {
                nArray[Companion.SiteDataWorkerPhase.CSV_LINKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SiteDataWorkerPhase.SITE_BACKUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SiteDataWorkerPhase.ENRICH_SITE_BACKUP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SiteDataWorkerPhase.UPLOAD_BACKUP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

