/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.site.ExportServiceFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.atlassian.jira.migration.workers.site.FileUploaderFactory;
import com.atlassian.jira.migration.workers.site.V3SiteDataProcessor;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateSiteDataCsvOperationFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001Bo\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ \u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u0002062\u0006\u00100\u001a\u0002012\u0006\u00107\u001a\u000204H\u0002J\u0010\u00108\u001a\u0002092\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lcom/atlassian/jira/migration/workers/site/V3SiteDataWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "fileUploaderFactory", "Lcom/atlassian/jira/migration/workers/site/FileUploaderFactory;", "exportServiceFactory", "Lcom/atlassian/jira/migration/export/site/ExportServiceFactory;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "generateCsvOperationFactory", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperationFactory;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/workers/site/FileUploaderFactory;Lcom/atlassian/jira/migration/export/site/ExportServiceFactory;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperationFactory;)V", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "taskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "getTaskType", "()Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "generateManualInterventionExportFile", "Ljava/nio/file/Path;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "fileName", "isWithoutAttachments", "", "getProcessor", "Lcom/atlassian/jira/migration/workers/site/V3SiteDataProcessor;", "exportOnlyMode", "process", "", "jira-migration-plugin"})
public final class V3SiteDataWorker
implements Worker {
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final JiraEventDetectionService jiraEventDetectionService;
    @NotNull
    private final FileUploaderFactory fileUploaderFactory;
    @NotNull
    private final ExportServiceFactory exportServiceFactory;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final GenerateSiteDataCsvOperationFactory generateCsvOperationFactory;
    @NotNull
    private final String id;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final MigrationTaskType taskType;

    @Inject
    public V3SiteDataWorker(@NotNull PlatformService platformService, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull FileUploaderFactory fileUploaderFactory, @NotNull ExportServiceFactory exportServiceFactory, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull ProjectManager projectManager, @NotNull IssueManager issueManager, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationEventBus migrationEventBus, @NotNull MigrationFeatures migrationFeatures, @NotNull DiscoveryService discoveryService, @NotNull GenerateSiteDataCsvOperationFactory generateCsvOperationFactory) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)fileUploaderFactory, (String)"fileUploaderFactory");
        Intrinsics.checkNotNullParameter((Object)exportServiceFactory, (String)"exportServiceFactory");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)generateCsvOperationFactory, (String)"generateCsvOperationFactory");
        this.platformService = platformService;
        this.metricsEventService = metricsEventService;
        this.jiraEventDetectionService = jiraEventDetectionService;
        this.fileUploaderFactory = fileUploaderFactory;
        this.exportServiceFactory = exportServiceFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.localFileDataOutput = localFileDataOutput;
        this.migrationEventBus = migrationEventBus;
        this.migrationFeatures = migrationFeatures;
        this.discoveryService = discoveryService;
        this.generateCsvOperationFactory = generateCsvOperationFactory;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.migrationProtocol = MigrationProtocol.V3;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.SITE));
        this.taskType = MigrationTaskType.JIRA_SITE_DATA_UPLOAD;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public MigrationTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public void process(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getProcessor(task, false).process();
    }

    @Nullable
    public final Path generateManualInterventionExportFile(@NotNull Task task, @NotNull String fileName, boolean isWithoutAttachments) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        V3SiteDataProcessor v3SiteDataProcessor = this.getProcessor(task, true);
        String[] stringArray = new String[]{fileName};
        Path path = Paths.get(((Object)this.localFileDataOutput.exportDirectory()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return v3SiteDataProcessor.generateEnrichedBackup(path, isWithoutAttachments);
    }

    private final V3SiteDataProcessor getProcessor(Task task, boolean exportOnlyMode) {
        V3SiteDataProcessor v3SiteDataProcessor;
        V3SiteDataProcessor it = v3SiteDataProcessor = new V3SiteDataProcessor(task, this.platformService, this.metricsEventService, this.jiraEventDetectionService, exportOnlyMode);
        boolean bl = false;
        it.setFileUploader(this.fileUploaderFactory.create());
        it.setExportService(this.exportServiceFactory.create());
        it.setJiraAuthenticationContext(this.jiraAuthenticationContext);
        it.setProjectManager(this.projectManager);
        it.setIssueManager(this.issueManager);
        it.setLocalFileDataOutput(this.localFileDataOutput);
        it.setMigrationEventBus(this.migrationEventBus);
        it.setMigrationFeatures(this.migrationFeatures);
        it.setDiscoveryService(this.discoveryService);
        it.setGenerateCsvOperationFactory(this.generateCsvOperationFactory);
        return v3SiteDataProcessor;
    }
}

