/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site.suboperations;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.AttachmentIdMappingsCsvExporter;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateCsvOperationResult;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateSiteDataCsvOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateAttachmentCsvOperation;", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperation;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "attachmentMediaIdService", "Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "attachmentsCsvExporter", "Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AttachmentIdMappingsCsvExporter;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AttachmentIdMappingsCsvExporter;)V", "metric", "Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "getMetric", "()Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "subOperationKey", "", "getSubOperationKey", "()Ljava/lang/String;", "generate", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateCsvOperationResult;", "operationKeyPrefix", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "heartbeat", "Lkotlin/Function0;", "", "Companion", "jira-migration-plugin"})
public final class GenerateAttachmentCsvOperation
extends GenerateSiteDataCsvOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final AttachmentMediaIdService attachmentMediaIdService;
    @NotNull
    private final AttachmentIdMappingsCsvExporter attachmentsCsvExporter;
    @NotNull
    private final MetricsEventService.OperationType metric;
    @NotNull
    private final String subOperationKey;
    @NotNull
    public static final String FILENAME = "attachments.csv";
    @NotNull
    private static final Logger log;

    public GenerateAttachmentCsvOperation(@NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull ProjectManager projectManager, @NotNull AttachmentMediaIdService attachmentMediaIdService, @NotNull AttachmentIdMappingsCsvExporter attachmentsCsvExporter) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)attachmentMediaIdService, (String)"attachmentMediaIdService");
        Intrinsics.checkNotNullParameter((Object)attachmentsCsvExporter, (String)"attachmentsCsvExporter");
        super(metricsEventService, jiraEventDetectionService);
        this.projectManager = projectManager;
        this.attachmentMediaIdService = attachmentMediaIdService;
        this.attachmentsCsvExporter = attachmentsCsvExporter;
        this.metric = MetricsEventService.OperationType.SITE_MEDIA_ID_GENERATION;
        this.subOperationKey = "media-id-gen";
    }

    @Override
    @NotNull
    public MetricsEventService.OperationType getMetric() {
        return this.metric;
    }

    @Override
    @NotNull
    public String getSubOperationKey() {
        return this.subOperationKey;
    }

    @Override
    @Nullable
    public GenerateCsvOperationResult generate(@NotNull String operationKeyPrefix, @NotNull Task task, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)operationKeyPrefix, (String)"operationKeyPrefix");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        OperationProcessor.runTimedOperation$default(this, this.getMetric(), operationKeyPrefix + '-' + this.getSubOperationKey(), null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, (Ref.ObjectRef<GenerateCsvOperationResult>)result2, task, heartbeat2){
            final /* synthetic */ GenerateAttachmentCsvOperation this$0;
            final /* synthetic */ Ref.ObjectRef<GenerateCsvOperationResult> $result;
            final /* synthetic */ Task $task;
            final /* synthetic */ Function0<Unit> $heartbeat;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                this.$task = $task;
                this.$heartbeat = $heartbeat;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                GenerateCsvOperationResult generateCsvOperationResult;
                void $this$forEach$iv;
                long totalAttachmentCount = 0L;
                List list = GenerateAttachmentCsvOperation.access$getProjectManager$p(this.this$0).getProjects();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
                Iterable iterable = list;
                Task task = this.$task;
                Object object = this.this$0;
                Function0<Unit> function0 = this.$heartbeat;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Project it = (Project)element$iv;
                    boolean bl = false;
                    GenerateAttachmentCsvOperation.Companion.getLog().info(task.getMigrationId() + '-' + task.getTaskId() + ": generating attachment media ids for " + it.getKey());
                    AttachmentMediaIdService attachmentMediaIdService = GenerateAttachmentCsvOperation.access$getAttachmentMediaIdService$p((GenerateAttachmentCsvOperation)object);
                    String string = it.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    int attachCount2 = attachmentMediaIdService.generateMediaFileIds(task, string, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(function0){
                        final /* synthetic */ Function0<Unit> $heartbeat;
                        {
                            this.$heartbeat = $heartbeat;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$heartbeat.invoke();
                        }
                    }), new DataFilterContext(null, null, null, 7, null));
                    totalAttachmentCount += (long)attachCount2;
                    GenerateAttachmentCsvOperation.Companion.getLog().info(task.getMigrationId() + '-' + task.getTaskId() + ": generated " + attachCount2 + " media ids for " + it.getKey());
                }
                Ref.ObjectRef<GenerateCsvOperationResult> objectRef = this.$result;
                Path path = GenerateAttachmentCsvOperation.access$getAttachmentsCsvExporter$p(this.this$0).getAttachmentsAndExportToCsv(this.$task.getCloudSite());
                if (path != null) {
                    void it;
                    object = path;
                    Ref.ObjectRef<GenerateCsvOperationResult> objectRef2 = objectRef;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"attachmentCsvSize", (Object)Files.size((Path)it)), TuplesKt.to((Object)"attachmentNumber", (Object)totalAttachmentCount)};
                    generateCsvOperationResult = new GenerateCsvOperationResult("attachments.csv", (Path)it, MapsKt.mapOf((Pair[])pairArray));
                    objectRef = objectRef2;
                } else {
                    generateCsvOperationResult = null;
                }
                objectRef.element = generateCsvOperationResult;
                return new OperationProcessor.OperationOutcome(totalAttachmentCount);
            }
        }, 4, null);
        return (GenerateCsvOperationResult)result2.element;
    }

    public static final /* synthetic */ ProjectManager access$getProjectManager$p(GenerateAttachmentCsvOperation $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ AttachmentIdMappingsCsvExporter access$getAttachmentsCsvExporter$p(GenerateAttachmentCsvOperation $this) {
        return $this.attachmentsCsvExporter;
    }

    public static final /* synthetic */ AttachmentMediaIdService access$getAttachmentMediaIdService$p(GenerateAttachmentCsvOperation $this) {
        return $this.attachmentMediaIdService;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(GenerateAttachmentCsvOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateAttachmentCsvOperation$Companion;", "", "()V", "FILENAME", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

