/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.site.suboperations;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.avatar.AvatarMediaIdService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaProcessorKt;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.AvatarIdMappingsCsvExporter;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateCsvOperationResult;
import com.atlassian.jira.migration.workers.site.suboperations.GenerateSiteDataCsvOperation;
import com.atlassian.migration.api.ContainerToken;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateAvatarCsvOperation;", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateSiteDataCsvOperation;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "avatarCsvExporter", "Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AvatarIdMappingsCsvExporter;", "avatarMediaIdService", "Lcom/atlassian/jira/migration/avatar/AvatarMediaIdService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AvatarIdMappingsCsvExporter;Lcom/atlassian/jira/migration/avatar/AvatarMediaIdService;)V", "metric", "Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "getMetric", "()Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "subOperationKey", "", "getSubOperationKey", "()Ljava/lang/String;", "generate", "Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateCsvOperationResult;", "operationKeyPrefix", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "heartbeat", "Lkotlin/Function0;", "", "Companion", "jira-migration-plugin"})
public final class GenerateAvatarCsvOperation
extends GenerateSiteDataCsvOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvatarIdMappingsCsvExporter avatarCsvExporter;
    @NotNull
    private final AvatarMediaIdService avatarMediaIdService;
    @NotNull
    private final MetricsEventService.OperationType metric;
    @NotNull
    private final String subOperationKey;
    @NotNull
    public static final String FILENAME = "avatars.csv";
    @NotNull
    private static final Logger log;

    public GenerateAvatarCsvOperation(@NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull AvatarIdMappingsCsvExporter avatarCsvExporter, @NotNull AvatarMediaIdService avatarMediaIdService) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)avatarCsvExporter, (String)"avatarCsvExporter");
        Intrinsics.checkNotNullParameter((Object)avatarMediaIdService, (String)"avatarMediaIdService");
        super(metricsEventService, jiraEventDetectionService);
        this.avatarCsvExporter = avatarCsvExporter;
        this.avatarMediaIdService = avatarMediaIdService;
        this.metric = MetricsEventService.OperationType.SITE_AVATAR_ID_GENERATION;
        this.subOperationKey = "media-id-gen";
    }

    @Override
    @NotNull
    public MetricsEventService.OperationType getMetric() {
        return this.metric;
    }

    @Override
    @NotNull
    public String getSubOperationKey() {
        return this.subOperationKey;
    }

    @Override
    @Nullable
    public GenerateCsvOperationResult generate(@NotNull String operationKeyPrefix, @NotNull Task task, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)operationKeyPrefix, (String)"operationKeyPrefix");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        OperationProcessor.runTimedOperation$default(this, this.getMetric(), operationKeyPrefix + '-' + this.getSubOperationKey(), null, (Function0)new Function0<OperationProcessor.OperationOutcome>(task, this, (Ref.ObjectRef<GenerateCsvOperationResult>)result2, heartbeat2){
            final /* synthetic */ Task $task;
            final /* synthetic */ GenerateAvatarCsvOperation this$0;
            final /* synthetic */ Ref.ObjectRef<GenerateCsvOperationResult> $result;
            final /* synthetic */ Function0<Unit> $heartbeat;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                this.$result = $result;
                this.$heartbeat = $heartbeat;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                GenerateCsvOperationResult generateCsvOperationResult;
                ContainerToken containerToken = new ContainerToken(AbstractMediaProcessorKt.getContainerToken(this.$task));
                GenerateAvatarCsvOperation.Companion.getLog().info(this.$task.getMigrationId() + '-' + this.$task.getTaskId() + ": generating avatar media ids for lift and shift migration");
                int totalAvatarCount2 = GenerateAvatarCsvOperation.access$getAvatarMediaIdService$p(this.this$0).generateMediaFileIds(containerToken, (Function0<Unit>)((Function0)new Function0<Unit>(this.$heartbeat){
                    final /* synthetic */ Function0<Unit> $heartbeat;
                    {
                        this.$heartbeat = $heartbeat;
                        super(0);
                    }

                    public final void invoke() {
                        this.$heartbeat.invoke();
                    }
                }));
                GenerateAvatarCsvOperation.Companion.getLog().info(this.$task.getMigrationId() + '-' + this.$task.getTaskId() + ": generated " + totalAvatarCount2 + " avatar media ids for lift and shift migration");
                Ref.ObjectRef<GenerateCsvOperationResult> objectRef = this.$result;
                Path path = GenerateAvatarCsvOperation.access$getAvatarCsvExporter$p(this.this$0).getAvatarsAndExportToCsv(this.$task.getCloudSite());
                if (path != null) {
                    void it;
                    Path path2 = path;
                    Ref.ObjectRef<GenerateCsvOperationResult> objectRef2 = objectRef;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"avatarCsvSize", (Object)Files.size((Path)it)), TuplesKt.to((Object)"avatarNumber", (Object)totalAvatarCount2)};
                    generateCsvOperationResult = new GenerateCsvOperationResult("avatars.csv", (Path)it, MapsKt.mapOf((Pair[])pairArray));
                    objectRef = objectRef2;
                } else {
                    generateCsvOperationResult = null;
                }
                objectRef.element = generateCsvOperationResult;
                return new OperationProcessor.OperationOutcome(totalAvatarCount2);
            }
        }, 4, null);
        return (GenerateCsvOperationResult)result2.element;
    }

    public static final /* synthetic */ AvatarMediaIdService access$getAvatarMediaIdService$p(GenerateAvatarCsvOperation $this) {
        return $this.avatarMediaIdService;
    }

    public static final /* synthetic */ AvatarIdMappingsCsvExporter access$getAvatarCsvExporter$p(GenerateAvatarCsvOperation $this) {
        return $this.avatarCsvExporter;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(GenerateAvatarCsvOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/workers/site/suboperations/GenerateAvatarCsvOperation$Companion;", "", "()V", "FILENAME", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

