/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.tombstone;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.serverdataextractors.usergroup.DeletedUserMapping;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraServerUserMappings;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.CloudSiteInfo;
import com.atlassian.jira.migration.usersmigrationservice.CreateTombstoneAccountRequest;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountEntity;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountRepository;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J8\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J0\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150%0\u00142\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J\"\u0010*\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00152\b\u0010,\u001a\u0004\u0018\u00010\u0015H\u0002J8\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010!\u001a\u00020\"2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J*\u0010.\u001a\u00020\u00172\b\u0010/\u001a\u0004\u0018\u0001002\u000e\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010\u00142\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "tombstoneAccountRepository", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "buildDeleteUserMappings", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/DeletedUserMapping;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "deletedUserKeys", "", "", "publishMappingsOnly", "", "onProgressUpdate", "Lkotlin/Function0;", "", "buildDeletedUserMappingForAllTombStones", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserInfo;", "buildUserInfoForDeletedUsers", "createAndSaveTombstoneAccounts", "", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountEntity;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "userKeys", "createTombstoneAccounts", "Lkotlin/Pair;", "evaluateIfPublishMappingsOnlyMode", "getDisplayName", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "loadDeletedUserEnrichWithAaid", "userKey", "aaid", "prepareAllTombstoneAccounts", "shouldReturnProjectSpecificTombstoneUsers", "usersExported", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraServerUserMappings;", "customersExported", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTombstoneAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TombstoneAccountManager.kt\ncom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n766#2:172\n857#2,2:173\n1549#2:175\n1620#2,3:176\n1655#2,8:179\n819#2:187\n847#2,2:188\n766#2:190\n857#2,2:191\n1549#2:193\n1620#2,3:194\n1194#2,2:197\n1222#2,4:199\n*S KotlinDebug\n*F\n+ 1 TombstoneAccountManager.kt\ncom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager\n*L\n35#1:172\n35#1:173,2\n36#1:175\n36#1:176,3\n78#1:179,8\n78#1:187\n78#1:188,2\n114#1:190\n114#1:191,2\n117#1:193\n117#1:194,3\n129#1:197,2\n129#1:199,4\n*E\n"})
public final class TombstoneAccountManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final TombstoneAccountRepository tombstoneAccountRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final DiscoveryService discoveryService;
    private static final Logger log = LoggerFactory.getLogger(TombstoneAccountManager.class);
    public static final int MAX_USER_KEY_LENGTH = 255;

    @Inject
    public TombstoneAccountManager(@NotNull UserManager userManager, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull TombstoneAccountRepository tombstoneAccountRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull UserExportMismatchService userExportMismatchService, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountRepository, (String)"tombstoneAccountRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.userManager = userManager;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.tombstoneAccountRepository = tombstoneAccountRepository;
        this.migrationFeatures = migrationFeatures;
        this.userExportMismatchService = userExportMismatchService;
        this.discoveryService = discoveryService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UserInfo> buildDeletedUserMappingForAllTombStones(@NotNull Task task, @NotNull Function0<Unit> onProgressUpdate2) {
        void $this$mapTo$iv$iv;
        TombstoneAccountEntity it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Iterable $this$filter$iv = this.tombstoneAccountRepository.loadAllAccounts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TombstoneAccountEntity)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getUserKey());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TombstoneAccountEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            onProgressUpdate2.invoke();
            collection.add(this.loadDeletedUserEnrichWithAaid(task, it.getUserKey(), it.getAaid()));
        }
        return (List)destination$iv$iv;
    }

    private final boolean shouldReturnProjectSpecificTombstoneUsers(JiraServerUserMappings usersExported, List<JiraUser> customersExported, UsersGroupsMigrationOption usersGroupsMigrationOption) {
        return usersExported == null || customersExported == null && !Intrinsics.areEqual((Object)usersGroupsMigrationOption.getJsdCustomersMigrationOption(), (Object)JsdCustomersMigrationOption.Companion.getNONE());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DeletedUserMapping buildDeleteUserMappings(@NotNull Task task, @NotNull List<String> deletedUserKeys2, boolean publishMappingsOnly, @NotNull Function0<Unit> onProgressUpdate2) {
        DeletedUserMapping deletedUserMapping2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(deletedUserKeys2, (String)"deletedUserKeys");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        UsersGroupsMigrationOption userGroupMigrationOption = DiscoveryService.retrievePlanFor$default(this.discoveryService, task, false, 2, null).getUsersGroupsMigrationOption();
        JiraServerUserMappings usersExported = this.userExportMismatchService.fetchUserExportObject(task.getMigrationId());
        List<JiraUser> customersExported = this.userExportMismatchService.fetchCustomerExportObject(task.getMigrationId());
        List<UserInfo> deletedUsersForProject = this.buildUserInfoForDeletedUsers(task, deletedUserKeys2, onProgressUpdate2);
        if (this.shouldReturnProjectSpecificTombstoneUsers(usersExported, customersExported, userGroupMigrationOption) || this.evaluateIfPublishMappingsOnlyMode(publishMappingsOnly)) {
            deletedUserMapping2 = new DeletedUserMapping(deletedUsersForProject);
        } else {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            List<UserInfo> allTombstoneUsers2 = this.buildDeletedUserMappingForAllTombStones(task, (Function0<Unit>)((Function0)buildDeleteUserMappings.allTombstoneUsers.1.INSTANCE));
            Set userKeysExported = CollectionsKt.toSet((Iterable)this.userExportMismatchService.extractAllExportedUserKeys(usersExported, !this.migrationFeatures.getDisableTombstoneCustomerSyncIssue() ? CollectionsKt.emptyList() : customersExported));
            Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)allTombstoneUsers2, (Iterable)deletedUsersForProject);
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                UserInfo it = (UserInfo)e$iv;
                boolean bl = false;
                String key$iv = it.getUserKey();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$filterNot = false;
            set$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                UserInfo it = (UserInfo)element$iv$iv;
                boolean bl = false;
                if (userKeysExported.contains(it.getUserKey())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            deletedUserMapping2 = new DeletedUserMapping(list);
        }
        return deletedUserMapping2;
    }

    public static /* synthetic */ DeletedUserMapping buildDeleteUserMappings$default(TombstoneAccountManager tombstoneAccountManager, Task task, List list, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return tombstoneAccountManager.buildDeleteUserMappings(task, list, bl, (Function0<Unit>)function0);
    }

    private final boolean evaluateIfPublishMappingsOnlyMode(boolean publishMappingsOnly) {
        return this.migrationFeatures.getSkipPublishingGlobalTombstoneUsersMappings() && publishMappingsOnly;
    }

    private final UserInfo loadDeletedUserEnrichWithAaid(Task task, String userKey, String aaid) {
        UserInfo userInfo;
        CharSequence charSequence;
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(userKey);
        if (user != null && !((charSequence = (CharSequence)user.getUsername()) == null || charSequence.length() == 0)) {
            String displayName = this.getDisplayName(user);
            String string = user.getUsername();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
            userInfo = new UserInfo(string, userKey, displayName, aaid);
        } else {
            log.debug(task.getMigrationId() + '-' + task.getMigrationTask().getTaskId() + ": Couldn't find user name for user key '" + userKey + "', using itself as a user name instead");
            userInfo = new UserInfo(userKey, userKey, "", aaid);
        }
        return userInfo;
    }

    private final String getDisplayName(ApplicationUser user) {
        String string = user.getDisplayName();
        if (string == null) {
            String string2;
            String it = string2 = user.getUsername();
            boolean bl = false;
            if (user.getDisplayName() == null) {
                log.info("User key '" + user.getKey() + "': Display name is null, defaulting to username '" + it + '\'');
            }
            String string3 = string2;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"also(...)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UserInfo> buildUserInfoForDeletedUsers(@NotNull Task task, @NotNull List<String> deletedUserKeys2, @NotNull Function0<Unit> onProgressUpdate2) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(deletedUserKeys2, (String)"deletedUserKeys");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Iterable $this$filter$iv = deletedUserKeys2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it) && it.length() <= 255)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredUserKeys = (List)destination$iv$iv;
        if (!((Collection)filteredUserKeys).isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<String, TombstoneAccountEntity> tombstoneAccounts = this.prepareAllTombstoneAccounts(filteredUserKeys, task.getCloudSite(), onProgressUpdate2);
            Iterable $this$map$iv = filteredUserKeys;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                TombstoneAccountEntity tombstoneAccountEntity = tombstoneAccounts.get(it);
                collection.add(this.loadDeletedUserEnrichWithAaid(task, (String)it, tombstoneAccountEntity != null ? tombstoneAccountEntity.getAaid() : null));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TombstoneAccountEntity> prepareAllTombstoneAccounts(List<String> deletedUserKeys2, CloudSite cloudSite2, Function0<Unit> onProgressUpdate2) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.tombstoneAccountRepository.loadAccounts(deletedUserKeys2);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TombstoneAccountEntity tombstoneAccountEntity = (TombstoneAccountEntity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getUserKey(), element$iv$iv);
        }
        Map existingTombstoneAccounts = destination$iv$iv;
        List userKeysWithoutTombstoneAccounts = CollectionsKt.minus((Iterable)deletedUserKeys2, (Iterable)existingTombstoneAccounts.keySet());
        return !((Collection)userKeysWithoutTombstoneAccounts).isEmpty() ? MapsKt.plus(this.createAndSaveTombstoneAccounts(cloudSite2, userKeysWithoutTombstoneAccounts, onProgressUpdate2), (Map)existingTombstoneAccounts) : existingTombstoneAccounts;
    }

    private final Map<String, TombstoneAccountEntity> createAndSaveTombstoneAccounts(CloudSite cloudSite2, List<String> userKeys, Function0<Unit> onProgressUpdate2) {
        return MapsKt.toMap((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.chunked((Iterable)userKeys, (int)100)), (Function1)((Function1)new Function1<List<? extends String>, Sequence<? extends Pair<? extends String, ? extends TombstoneAccountEntity>>>(this, cloudSite2, onProgressUpdate2){
            final /* synthetic */ TombstoneAccountManager this$0;
            final /* synthetic */ CloudSite $cloudSite;
            final /* synthetic */ Function0<Unit> $onProgressUpdate;
            {
                this.this$0 = $receiver;
                this.$cloudSite = $cloudSite;
                this.$onProgressUpdate = $onProgressUpdate;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<String, TombstoneAccountEntity>> invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)TombstoneAccountManager.access$createTombstoneAccounts(this.this$0, this.$cloudSite, it)), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Pair<? extends String, ? extends TombstoneAccountEntity>>(this.this$0){
                    final /* synthetic */ TombstoneAccountManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Pair<String, TombstoneAccountEntity> invoke(@NotNull Pair<String, String> pair) {
                        Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                        String userKey = (String)pair.component1();
                        String aaid = (String)pair.component2();
                        return TuplesKt.to((Object)userKey, (Object)TombstoneAccountManager.access$getTombstoneAccountRepository$p(this.this$0).save(userKey, aaid));
                    }
                })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends TombstoneAccountEntity>, Unit>(this.$onProgressUpdate){
                    final /* synthetic */ Function0<Unit> $onProgressUpdate;
                    {
                        this.$onProgressUpdate = $onProgressUpdate;
                        super(1);
                    }

                    public final void invoke(@NotNull Pair<String, ? extends TombstoneAccountEntity> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        this.$onProgressUpdate.invoke();
                    }
                }));
            }
        })));
    }

    private final List<Pair<String, String>> createTombstoneAccounts(CloudSite cloudSite2, List<String> userKeys) {
        List<String> newTombstoneAccountIds = this.usersMigrationServiceClient.createTombstoneAccounts(cloudSite2.getContainerToken(), new CreateTombstoneAccountRequest(new CloudSiteInfo(cloudSite2.getCloudId(), cloudSite2.getCloudUrl(), ""), null, 2, null), userKeys.size()).getTombstoneAccountIds();
        return CollectionsKt.zip((Iterable)userKeys, (Iterable)newTombstoneAccountIds);
    }

    public static final /* synthetic */ List access$createTombstoneAccounts(TombstoneAccountManager $this, CloudSite cloudSite2, List userKeys) {
        return $this.createTombstoneAccounts(cloudSite2, userKeys);
    }

    public static final /* synthetic */ TombstoneAccountRepository access$getTombstoneAccountRepository$p(TombstoneAccountManager $this) {
        return $this.tombstoneAccountRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager$Companion;", "", "()V", "MAX_USER_KEY_LENGTH", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

