/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.tombstone;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountEntity;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountRepository;", "", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "loadAccounts", "", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountEntity;", "userKeys", "", "loadAllAccounts", "save", "userKey", "aaid", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTombstoneAccountRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TombstoneAccountRepository.kt\ncom/atlassian/jira/migration/workers/tombstone/TombstoneAccountRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,71:1\n1#2:72\n1360#3:73\n1446#3,2:74\n1448#3,3:78\n37#4,2:76\n*S KotlinDebug\n*F\n+ 1 TombstoneAccountRepository.kt\ncom/atlassian/jira/migration/workers/tombstone/TombstoneAccountRepository\n*L\n44#1:73\n44#1:74,2\n44#1:78,3\n48#1:76,2\n*E\n"})
public final class TombstoneAccountRepository {
    @NotNull
    private final ActiveObjects activeObjects;
    private final Logger log;

    @Inject
    public TombstoneAccountRepository(@NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter((Object)activeObjects, (String)"activeObjects");
        this.activeObjects = activeObjects;
        this.log = LoggerFactory.getLogger(TombstoneAccountRepository.class);
    }

    @NotNull
    public final TombstoneAccountEntity save(@NotNull String userKey, @NotNull String aaid) {
        RawEntity rawEntity;
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)aaid, (String)"aaid");
        try {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"USER_KEY", (Object)userKey), TuplesKt.to((Object)"AAID", (Object)aaid)};
            rawEntity = this.activeObjects.create(TombstoneAccountEntity.class, MapsKt.mapOf((Pair[])pairArray));
            Intrinsics.checkNotNull((Object)rawEntity);
            rawEntity = (TombstoneAccountEntity)rawEntity;
        }
        catch (RuntimeException e) {
            TombstoneAccountEntity entity;
            this.log.warn("Exception occur while inserting a new tombstone account with userkey " + userKey, (Throwable)e);
            TombstoneAccountEntity tombstoneAccountEntity = entity = (TombstoneAccountEntity)this.activeObjects.get(TombstoneAccountEntity.class, (Object)userKey);
            Intrinsics.checkNotNull((Object)tombstoneAccountEntity);
            rawEntity = tombstoneAccountEntity;
        }
        return rawEntity;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TombstoneAccountEntity> loadAccounts(@NotNull List<String> userKeys) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userKeys, (String)"userKeys");
        if (!(!((Collection)userKeys).isEmpty())) {
            boolean $i$a$-require-TombstoneAccountRepository$loadAccounts$22 = false;
            String $i$a$-require-TombstoneAccountRepository$loadAccounts$22 = "userKeys can not be empty";
            throw new IllegalArgumentException($i$a$-require-TombstoneAccountRepository$loadAccounts$22.toString());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)userKeys, (int)500);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            RawEntity[] rawEntityArray = this.activeObjects.find(TombstoneAccountEntity.class, CollectionsKt.joinToString$default((Iterable)it, null, (CharSequence)"USER_KEY IN (", (CharSequence)")", (int)0, null, (Function1)loadAccounts.2.1.INSTANCE, (int)25, null), (Object[])Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])rawEntityArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<TombstoneAccountEntity> loadAllAccounts() {
        RawEntity[] rawEntityArray = this.activeObjects.find(TombstoneAccountEntity.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.toList((Object[])rawEntityArray);
    }
}

