/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraServerUserMappings;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.MergedUsers;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsProcessorMetricService;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsProcessorService;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsUtil;
import com.atlassian.migration.udc.common.model.user.AccountType;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u00105\u001a\u000206H&J\b\u00107\u001a\u00020$H\u0016J\u001e\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020:H\u0002J\u0010\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020:H\u0002J\u0016\u0010@\u001a\u00020$2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002000/H\u0007J\u0016\u0010B\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0007J\u0014\u0010C\u001a\u00020$2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0/J\b\u0010F\u001a\u00020$H&J\u0014\u0010G\u001a\u00020$2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010 H&J\u001e\u0010I\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KH&J\u0010\u0010M\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020:H&J\u0018\u0010N\u001a\u00020$2\u0006\u0010O\u001a\u00020P2\u0006\u0010\u001f\u001a\u00020 H&J\u0010\u0010?\u001a\u00020:2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010=\u001a\u00020:2\u0006\u00109\u001a\u00020:H\u0002R!\u0010\u0013\u001a\u00020\u00148FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u0002000/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/AbstractUsersGroupsProcessor;", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "usersGroupsProcessorService", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorService;", "usersGroupsProcessorMetricService", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;", "userEmailFixer", "Lcom/atlassian/jira/migration/email/UserEmailFixer;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "usersGroupsUtil", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorService;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;Lcom/atlassian/jira/migration/email/UserEmailFixer;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;)V", "data", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "getData$annotations", "()V", "getData", "()Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "data$delegate", "Lkotlin/Lazy;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "migrationScopeId", "", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "operationKeyPrefix", "getOperationKeyPrefix", "()Ljava/lang/String;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getPlan", "()Lcom/atlassian/jira/migration/plan/Plan;", "usersEligibleForMigrationWithDuplicateEmails", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "getUsersEligibleForMigrationWithDuplicateEmails", "()Ljava/util/List;", "getUsersGroupsProcessorMetricService", "()Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;", "getHeartbeatFrequency", "", "process", "processUserGroupMigrationData", "jiraUserGroupMigrationData", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "usersForMappings", "processUsersAndGroups", "usersForUserMigration", "processUsersMappings", "usersForUserMapping", "processUsersWithGlobalEmailFixes", "usersToMigrate", "processUsersWithoutGlobalEmailFixes", "publishTombstoneMappings", "deletedUsers", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserInfo;", "sendFinalStatus", "sendHeartbeat", "msg", "uploadTombStoneUsers", "tombstoneUsers", "", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "uploadUsersAndGroups", "uploadUsersMappings", "userMappings", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraServerUserMappings;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractUsersGroupsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractUsersGroupsProcessor.kt\ncom/atlassian/jira/migration/workers/usersgroups/AbstractUsersGroupsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1603#2,9:254\n1855#2:263\n1856#2:266\n1612#2:267\n1549#2:268\n1620#2,3:269\n1#3:264\n1#3:265\n*S KotlinDebug\n*F\n+ 1 AbstractUsersGroupsProcessor.kt\ncom/atlassian/jira/migration/workers/usersgroups/AbstractUsersGroupsProcessor\n*L\n77#1:254,9\n77#1:263\n77#1:266\n77#1:267\n78#1:268\n78#1:269,3\n77#1:265\n*E\n"})
public abstract class AbstractUsersGroupsProcessor
extends OperationProcessor {
    @NotNull
    private final Task task;
    @NotNull
    private final UsersGroupsProcessorService usersGroupsProcessorService;
    @NotNull
    private final UsersGroupsProcessorMetricService usersGroupsProcessorMetricService;
    @NotNull
    private final UserEmailFixer userEmailFixer;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final UsersGroupsUtil usersGroupsUtil;
    @NotNull
    private final String migrationScopeId;
    @NotNull
    private final Plan plan;
    @NotNull
    private final Lazy data$delegate;

    public AbstractUsersGroupsProcessor(@NotNull Task task, @NotNull UsersGroupsProcessorService usersGroupsProcessorService, @NotNull UsersGroupsProcessorMetricService usersGroupsProcessorMetricService, @NotNull UserEmailFixer userEmailFixer, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull UsersGroupsUtil usersGroupsUtil) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)usersGroupsProcessorService, (String)"usersGroupsProcessorService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsProcessorMetricService, (String)"usersGroupsProcessorMetricService");
        Intrinsics.checkNotNullParameter((Object)userEmailFixer, (String)"userEmailFixer");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)usersGroupsUtil, (String)"usersGroupsUtil");
        super(metricsEventService, jiraEventDetectionService);
        this.task = task;
        this.usersGroupsProcessorService = usersGroupsProcessorService;
        this.usersGroupsProcessorMetricService = usersGroupsProcessorMetricService;
        this.userEmailFixer = userEmailFixer;
        this.migrationScopeManager = migrationScopeManager;
        this.usersGroupsUtil = usersGroupsUtil;
        this.migrationScopeId = this.usersGroupsProcessorService.getMigrationScope(this.task);
        this.plan = this.usersGroupsProcessorService.retrieveLazyPlan(this.task);
        this.data$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<UsersGroupsExtractionResult>(this){
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final UsersGroupsExtractionResult invoke() {
                UsersGroupsExtractionResult usersGroupsExtractionResult;
                this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": exporting users & groups with migrationScopeId " + AbstractUsersGroupsProcessor.access$getMigrationScopeId$p(this.this$0));
                if (AbstractUsersGroupsProcessor.access$getUsersGroupsProcessorService$p(this.this$0).userMigrationNotRequired(this.this$0.getPlan())) {
                    this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": 'no users migration' feature flag is enabled, users export was skipped, sending empty export file to Cloud");
                    usersGroupsExtractionResult = UsersGroupsExtractionResult.Companion.getEMPTY();
                } else if (this.this$0.getPlan().isLegacyAttachmentsOnly()) {
                    this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": attachments only plan, users export was skipped, sending empty export file to Cloud");
                    usersGroupsExtractionResult = UsersGroupsExtractionResult.Companion.getEMPTY();
                } else {
                    usersGroupsExtractionResult = (UsersGroupsExtractionResult)OperationProcessor.runTimedOperationWithResult$default(this.this$0, MetricsEventService.OperationType.USER_EXPORT, this.this$0.getOperationKeyPrefix() + "-export", null, (Function0)new Function0<OperationProcessor.OperationOutcomeWithResult<UsersGroupsExtractionResult>>(this.this$0){
                        final /* synthetic */ AbstractUsersGroupsProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final OperationProcessor.OperationOutcomeWithResult<UsersGroupsExtractionResult> invoke() {
                            UsersGroupsExtractionResult usersGroupsExtracted = AbstractUsersGroupsProcessor.access$getUsersGroupsProcessorService$p(this.this$0).extractUsersGroups(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0), this.this$0.getLog(), this.this$0.getOnProgressUpdate(), this.this$0.getPlan().getId());
                            UsersGroupsExtractionResult updatedUsersGroupsExtracted = AbstractUsersGroupsProcessor.access$getUsersGroupsUtil$p(this.this$0).shouldSkipJwmAccessPermissionsInMigration(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getCloudSite()) ? AbstractUsersGroupsProcessor.access$getUsersGroupsUtil$p(this.this$0).skipJwmProductAccessPermissions(usersGroupsExtracted) : usersGroupsExtracted;
                            return new OperationProcessor.OperationOutcomeWithResult<UsersGroupsExtractionResult>(LongExtensionsKt.safeDivide(Long.valueOf(updatedUsersGroupsExtracted.getUsers().size()), 2), updatedUsersGroupsExtracted);
                        }
                    }, 4, null);
                }
                return usersGroupsExtractionResult;
            }
        }));
    }

    @NotNull
    public final UsersGroupsProcessorMetricService getUsersGroupsProcessorMetricService() {
        return this.usersGroupsProcessorMetricService;
    }

    @NotNull
    public abstract String getOperationKeyPrefix();

    @NotNull
    public abstract Logger getLog();

    @NotNull
    public final Plan getPlan() {
        return this.plan;
    }

    @NotNull
    public final UsersGroupsExtractionResult getData() {
        Lazy lazy = this.data$delegate;
        return (UsersGroupsExtractionResult)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getData$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<JiraUser> getUsersEligibleForMigrationWithDuplicateEmails() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getData().getUsers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair pair2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            JiraUser jiraUser = (JiraUser)element$iv$iv;
            boolean bl2 = false;
            if (jiraUser.getUserKey() != null) {
                String it;
                boolean bl3 = false;
                pair2 = TuplesKt.to((Object)it, (Object)jiraUser);
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JiraUser jiraUser = (JiraUser)pair.component2();
            collection.add(jiraUser);
        }
        return (List)destination$iv$iv;
    }

    public void process() {
        if (!(!this.plan.isV2AttachmentsOnly())) {
            boolean $i$a$-require-AbstractUsersGroupsProcessor$process$32 = false;
            String $i$a$-require-AbstractUsersGroupsProcessor$process$32 = "UserGroupsWorker should never be called for project mode ATTACHMENTS_ONLY_V2";
            throw new IllegalArgumentException($i$a$-require-AbstractUsersGroupsProcessor$process$32.toString());
        }
        if (!(this.plan.getUsersGroupsMigrationOption().getMode() != UsersGroupsMigrationOption.MigrationMode.NONE)) {
            boolean bl = false;
            String string = "UserGroupsWorker should never be called for users and groups mode NONE";
            throw new IllegalArgumentException(string.toString());
        }
        this.usersGroupsProcessorMetricService.postStartEvent(this.task);
        this.usersGroupsProcessorMetricService.postFeatureFlagsEvents(this.task);
        try {
            this.usersGroupsProcessorMetricService.postMigrationConfigEvent(this.task);
            this.processUsersWithGlobalEmailFixes(this.getUsersEligibleForMigrationWithDuplicateEmails());
            this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": notified MO complete for users and groups");
            this.sendFinalStatus();
            this.usersGroupsProcessorMetricService.sendSuccessfulEvent(this.task);
        }
        catch (CommandCancelledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.usersGroupsProcessorMetricService.postFailedEvent(this.task, ex);
            this.usersGroupsProcessorMetricService.sendFailedEvent(this.task);
            this.usersGroupsProcessorMetricService.storeStackTrace(this.task, ex);
            throw ex;
        }
    }

    @VisibleForTesting
    public final void processUsersWithoutGlobalEmailFixes(@NotNull List<JiraUser> usersEligibleForMigrationWithDuplicateEmails) {
        Intrinsics.checkNotNullParameter(usersEligibleForMigrationWithDuplicateEmails, (String)"usersEligibleForMigrationWithDuplicateEmails");
        Map<JiraUser, MergedUsers> usersWithoutDuplicateEmails = this.userEmailFixer.mergeDuplicateUsers(usersEligibleForMigrationWithDuplicateEmails);
        JiraUserGroupMigrationData jiraUserGroupMigrationData = this.userEmailFixer.buildJiraUserGroupMigrationData(usersWithoutDuplicateEmails, usersEligibleForMigrationWithDuplicateEmails, this.getData(), this.migrationScopeId);
        this.processUserGroupMigrationData(jiraUserGroupMigrationData, usersEligibleForMigrationWithDuplicateEmails);
    }

    @VisibleForTesting
    public final void processUsersWithGlobalEmailFixes(@NotNull List<JiraUser> usersToMigrate) {
        Intrinsics.checkNotNullParameter(usersToMigrate, (String)"usersToMigrate");
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(this.task.getCloudSite());
        List<JiraUser> fixedUsers = this.userEmailFixer.safelyFixAllEmailInMemory(usersToMigrate, AccountType.USER, migrationScopeId2, this.plan.getPreflightCheckExecutionId(), this.task.getCloudSite().getContainerToken(), true, true).allFixedUsers();
        Map<JiraUser, MergedUsers> distinctUsers = this.userEmailFixer.mergeDuplicateUsers(fixedUsers);
        List<JiraUser> allUsersWithFixedEmailCasing = this.userEmailFixer.fixEmailCasingForDuplicateEmails(CollectionsKt.toList((Iterable)distinctUsers.keySet()), fixedUsers);
        JiraUserGroupMigrationData jiraUserGroupMigrationData = this.userEmailFixer.buildJiraUserGroupMigrationData(distinctUsers, allUsersWithFixedEmailCasing, this.getData(), migrationScopeId2);
        this.processUserGroupMigrationData(jiraUserGroupMigrationData, allUsersWithFixedEmailCasing);
    }

    private final void processUserGroupMigrationData(JiraUserGroupMigrationData jiraUserGroupMigrationData, List<JiraUser> usersForMappings) {
        this.processUsersAndGroups(this.usersForUserMigration(jiraUserGroupMigrationData));
        this.processUsersMappings(this.usersForUserMapping(JiraUserGroupMigrationData.copy$default(jiraUserGroupMigrationData, usersForMappings, null, null, null, 14, null)));
        this.publishTombstoneMappings(this.usersGroupsProcessorMetricService.buildDeletedUserMapping(this.task, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractUsersGroupsProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        })));
    }

    private final JiraUserGroupMigrationData usersForUserMigration(JiraUserGroupMigrationData jiraUserGroupMigrationData) {
        return (JiraUserGroupMigrationData)OperationProcessor.runTimedOperationWithResult$default(this, MetricsEventService.OperationType.USER_FILTER, this.getOperationKeyPrefix() + "-filter-invalid", null, (Function0)new Function0<OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData>>(jiraUserGroupMigrationData, this){
            final /* synthetic */ JiraUserGroupMigrationData $jiraUserGroupMigrationData;
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            {
                this.$jiraUserGroupMigrationData = $jiraUserGroupMigrationData;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData> invoke() {
                JiraUserGroupMigrationData jiraUserGroupMigrationData = this.$jiraUserGroupMigrationData;
                AbstractUsersGroupsProcessor abstractUsersGroupsProcessor = this.this$0;
                JiraUserGroupMigrationData it = jiraUserGroupMigrationData;
                boolean bl = false;
                abstractUsersGroupsProcessor.getLog().info(StringsKt.trimIndent((String)("\n                " + AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getTaskId() + ": exported users & groups filter for user migration completed: \n                " + it.getUsers().size() + " users, " + it.getGroups().size() + " groups \n                        ")));
                return new OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData>(LongExtensionsKt.safeDivide(Long.valueOf(this.$jiraUserGroupMigrationData.getUsers().size()), 2), this.$jiraUserGroupMigrationData);
            }
        }, 4, null);
    }

    private final JiraUserGroupMigrationData usersForUserMapping(JiraUserGroupMigrationData jiraUserGroupMigrationData) {
        return (JiraUserGroupMigrationData)OperationProcessor.runTimedOperationWithResult$default(this, MetricsEventService.OperationType.USER_FILTER_DUPLICATE, this.getOperationKeyPrefix() + "-filter-duplicate", null, (Function0)new Function0<OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData>>(jiraUserGroupMigrationData, this){
            final /* synthetic */ JiraUserGroupMigrationData $jiraUserGroupMigrationData;
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            {
                this.$jiraUserGroupMigrationData = $jiraUserGroupMigrationData;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData> invoke() {
                JiraUserGroupMigrationData jiraUserGroupMigrationData = this.$jiraUserGroupMigrationData;
                AbstractUsersGroupsProcessor abstractUsersGroupsProcessor = this.this$0;
                JiraUserGroupMigrationData it = jiraUserGroupMigrationData;
                boolean bl = false;
                abstractUsersGroupsProcessor.getLog().info(StringsKt.trimIndent((String)("\n                " + AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getTaskId() + ": exported users & groups filter for user mapping completed: \n                " + it.getUsers().size() + " users, " + it.getGroups().size() + " groups\n                        ")));
                return new OperationProcessor.OperationOutcomeWithResult<JiraUserGroupMigrationData>(LongExtensionsKt.safeDivide(Long.valueOf(this.$jiraUserGroupMigrationData.getUsers().size()), 2), this.$jiraUserGroupMigrationData);
            }
        }, 4, null);
    }

    public final void publishTombstoneMappings(@NotNull List<UserInfo> deletedUsers) {
        Intrinsics.checkNotNullParameter(deletedUsers, (String)"deletedUsers");
        if (this.usersGroupsProcessorService.shouldPublishTombStoneMappings(this.plan)) {
            String migrationScopeId2 = this.migrationScopeId;
            boolean bl = false;
            OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.USER_PUBLISH_TOMBSTONE_MAPPINGS, this.getOperationKeyPrefix() + "-publish-tombstone-mappings", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(deletedUsers, this, migrationScopeId2){
                final /* synthetic */ List<UserInfo> $deletedUsers;
                final /* synthetic */ AbstractUsersGroupsProcessor this$0;
                final /* synthetic */ String $migrationScopeId;
                {
                    this.$deletedUsers = $deletedUsers;
                    this.this$0 = $receiver;
                    this.$migrationScopeId = $migrationScopeId;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final OperationProcessor.OperationOutcome invoke() {
                    long l;
                    List<E> list;
                    List<E> list2;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$deletedUsers;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void user;
                        UserInfo userInfo = (UserInfo)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = user.getAaid();
                        Intrinsics.checkNotNull((Object)string);
                        collection.add(new TombstoneUser(string, user.getUserName(), user.getUserKey(), user.getDisplayName()));
                    }
                    List<E> it = list2 = (List<E>)destination$iv$iv;
                    boolean bl = false;
                    List<E> list3 = list = !((Collection)it).isEmpty() ? list2 : null;
                    if (list != null) {
                        List<E> list4 = list;
                        AbstractUsersGroupsProcessor abstractUsersGroupsProcessor = this.this$0;
                        String string = this.$migrationScopeId;
                        List<E> $this$invoke_u24lambda_u242 = list4;
                        boolean bl2 = false;
                        Set uniqueUsers = CollectionsKt.toSet((Iterable)$this$invoke_u24lambda_u242);
                        abstractUsersGroupsProcessor.uploadTombStoneUsers(string, uniqueUsers);
                        abstractUsersGroupsProcessor.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(abstractUsersGroupsProcessor).getTaskId() + ": uploaded tombstone mappings to UMS");
                        l = LongExtensionsKt.safeDivide(Long.valueOf(uniqueUsers.size()), 2);
                    } else {
                        l = 0L;
                    }
                    long l2 = l;
                    return new OperationProcessor.OperationOutcome(l2);
                }
            }, 4, null);
        }
    }

    private final void processUsersAndGroups(JiraUserGroupMigrationData usersForUserMigration2) {
        JiraUserGroupMigrationData $this$processUsersAndGroups_u24lambda_u246 = usersForUserMigration2;
        boolean bl = false;
        OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.USER_UPLOAD_DATA, this.getOperationKeyPrefix() + "-upload-data", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, $this$processUsersAndGroups_u24lambda_u246){
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            final /* synthetic */ JiraUserGroupMigrationData $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                this.this$0.uploadUsersAndGroups(this.$this_with);
                this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": uploaded users & groups data to MO");
                return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(Long.valueOf(this.$this_with.size()), 2));
            }
        }, 4, null);
    }

    private final void processUsersMappings(JiraUserGroupMigrationData usersForUserMapping2) {
        JiraServerUserMappings userMappings2 = (JiraServerUserMappings)OperationProcessor.runTimedOperationWithResult$default(this, MetricsEventService.OperationType.USER_EXPORT_MAPPINGS, this.getOperationKeyPrefix() + "-export-mappings", null, (Function0)new Function0<OperationProcessor.OperationOutcomeWithResult<JiraServerUserMappings>>(this, usersForUserMapping2){
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            final /* synthetic */ JiraUserGroupMigrationData $usersForUserMapping;
            {
                this.this$0 = $receiver;
                this.$usersForUserMapping = $usersForUserMapping;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcomeWithResult<JiraServerUserMappings> invoke() {
                JiraServerUserMappings result2 = AbstractUsersGroupsProcessor.access$getUsersGroupsProcessorService$p(this.this$0).mapUserEmailToUserInfo(this.$usersForUserMapping, this.this$0.getOnProgressUpdate());
                this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": export user mappings: " + result2.getEmailToUserInfo().size() + " mappings");
                return new OperationProcessor.OperationOutcomeWithResult<JiraServerUserMappings>(LongExtensionsKt.safeDivide(Long.valueOf(result2.getEmailToUserInfo().size()), 2), result2);
            }
        }, 4, null);
        OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.USER_UPLOAD_MAPPINGS, this.getOperationKeyPrefix() + "-upload-mappings", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, userMappings2){
            final /* synthetic */ AbstractUsersGroupsProcessor this$0;
            final /* synthetic */ JiraServerUserMappings $userMappings;
            {
                this.this$0 = $receiver;
                this.$userMappings = $userMappings;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                this.this$0.uploadUsersMappings(this.$userMappings, AbstractUsersGroupsProcessor.access$getMigrationScopeId$p(this.this$0));
                this.this$0.getLog().info(AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractUsersGroupsProcessor.access$getTask$p(this.this$0).getTaskId() + ": uploaded users mappings data to MO");
                return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(Long.valueOf(this.$userMappings.getEmailToUserInfo().size()), 2));
            }
        }, 4, null);
    }

    public abstract void uploadTombStoneUsers(@NotNull String var1, @NotNull Set<TombstoneUser> var2);

    public abstract void uploadUsersAndGroups(@NotNull JiraUserGroupMigrationData var1);

    public abstract void uploadUsersMappings(@NotNull JiraServerUserMappings var1, @NotNull String var2);

    @NotNull
    public abstract Function1<ExportUpdate, Unit> getOnProgressUpdate();

    public abstract void sendHeartbeat(@Nullable String var1);

    public static /* synthetic */ void sendHeartbeat$default(AbstractUsersGroupsProcessor abstractUsersGroupsProcessor, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendHeartbeat");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractUsersGroupsProcessor.sendHeartbeat(string);
    }

    public abstract long getHeartbeatFrequency();

    public abstract void sendFinalStatus();

    public static final /* synthetic */ Task access$getTask$p(AbstractUsersGroupsProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ UsersGroupsProcessorService access$getUsersGroupsProcessorService$p(AbstractUsersGroupsProcessor $this) {
        return $this.usersGroupsProcessorService;
    }

    public static final /* synthetic */ String access$getMigrationScopeId$p(AbstractUsersGroupsProcessor $this) {
        return $this.migrationScopeId;
    }

    public static final /* synthetic */ UsersGroupsUtil access$getUsersGroupsUtil$p(AbstractUsersGroupsProcessor $this) {
        return $this.usersGroupsUtil;
    }
}

