/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.IdsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroup;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithMemberships;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissionsMapper;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUsersAndGroupsService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.References;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersAndGroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersWithReferences;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.usersgroups.ScopedUserExtractor;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsExtractor;
import com.atlassian.jira.migration.workers.usersgroups.UsersWithMembershipsExtractor;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 S2\u00020\u0001:\u0001SBw\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&H\u0002J;\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2#\b\u0002\u0010%\u001a\u001d\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/\u0012\u0004\u0012\u00020(0&2\u0006\u00100\u001a\u000201J\u0095\u0001\u0010)\u001a\u00020*2\u0006\u00102\u001a\u0002012\f\u00103\u001a\b\u0012\u0004\u0012\u0002010 2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0010\b\u0002\u0010<\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010 2\b\u0010>\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u0010B\u001a\u00020C2\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&\u00a2\u0006\u0002\u0010DJ\u008b\u0001\u0010)\u001a\u00020*2\f\u00103\u001a\b\u0012\u0004\u0012\u0002010 2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0010\b\u0002\u0010<\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010 2\u0006\u0010E\u001a\u00020F2\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010@\u001a\u0004\u0018\u00010A2\b\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u0010B\u001a\u00020CH\u0002\u00a2\u0006\u0002\u0010GJ,\u0010H\u001a\u00020*2\u0006\u0010I\u001a\u00020J2\u0006\u00104\u001a\u0002052\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&JL\u0010K\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0M\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0L2\u0006\u0010O\u001a\u00020P2\u0006\u00104\u001a\u0002052\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\u0006\u0010E\u001a\u00020FJ\f\u0010Q\u001a\u00020**\u00020*H\u0002J(\u0010R\u001a\u00020**\u00020J2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor;", "", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "jiraUsersAndGroupsService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "jiraGroupReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;", "jiraGroupWithPermissionsMapper", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupWithPermissionsMapper;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "usersWithMembershipsExtractor", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersWithMembershipsExtractor;", "jsmCustomerReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupWithPermissionsMapper;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/workers/usersgroups/UsersWithMembershipsExtractor;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/utility/JsmUtility;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "buildGroupsPermissions", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupWithPermissions;", "groups", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroup;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "extract", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "Lkotlin/ParameterName;", "name", "update", "planId", "", "id", "projectKeys", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "startedUser", "Lcom/atlassian/jira/user/ApplicationUser;", "advancedRoadmapsPlanIds", "", "crossProjectConfig", "Lcom/atlassian/jira/migration/plan/CrossProjectConfig;", "migrateArchivedIssues", "", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "(Ljava/lang/String;Ljava/util/List;Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/MigrationType;Lcom/atlassian/jira/user/ApplicationUser;Ljava/util/List;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Ljava/lang/String;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;Lkotlin/jvm/functions/Function1;)Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "taskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "(Ljava/util/List;Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/MigrationType;Ljava/util/List;Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;Lkotlin/jvm/functions/Function1;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Ljava/lang/String;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;)Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "getReferencedExtractionResult", "usersAndGroupsWithReferences", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersAndGroupsWithReferences;", "getScopedCustomers", "Lkotlin/Pair;", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "referencedUserReader", "Lcom/atlassian/jira/migration/workers/usersgroups/ScopedUserExtractor;", "alsoLogUsersAndGroupsBreakdown", "toUserGroupExtractionResult", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersGroupsExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersGroupsExtractor.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,292:1\n1549#2:293\n1620#2,3:294\n766#2:297\n857#2,2:298\n1549#2:300\n1620#2,3:301\n1238#2,4:306\n1271#2,2:310\n1285#2,4:312\n1179#2,2:316\n1253#2,4:318\n468#3:304\n414#3:305\n*S KotlinDebug\n*F\n+ 1 UsersGroupsExtractor.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor\n*L\n197#1:293\n197#1:294,3\n222#1:297\n222#1:298,2\n233#1:300\n233#1:301,3\n256#1:306,4\n262#1:310,2\n262#1:312,4\n268#1:316,2\n268#1:318,4\n256#1:304\n256#1:305\n*E\n"})
public final class UsersGroupsExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final JiraUsersAndGroupsService jiraUsersAndGroupsService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final JiraGroupReader jiraGroupReader;
    @NotNull
    private final JiraGroupWithPermissionsMapper jiraGroupWithPermissionsMapper;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final UsersWithMembershipsExtractor usersWithMembershipsExtractor;
    @NotNull
    private final JsmCustomerReader jsmCustomerReader;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    private static final Logger log = LoggerFactory.getLogger(UsersGroupsExtractor.class);

    @Inject
    public UsersGroupsExtractor(@NotNull ExportFacade exportFacade, @NotNull UserManager userManager, @NotNull ProjectManager projectManager, @NotNull JiraUsersAndGroupsService jiraUsersAndGroupsService, @NotNull DiscoveryService discoveryService, @NotNull JiraGroupReader jiraGroupReader, @NotNull JiraGroupWithPermissionsMapper jiraGroupWithPermissionsMapper, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull UsersWithMembershipsExtractor usersWithMembershipsExtractor, @NotNull JsmCustomerReader jsmCustomerReader, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull JsmUtility jsmUtility, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)jiraUsersAndGroupsService, (String)"jiraUsersAndGroupsService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)jiraGroupReader, (String)"jiraGroupReader");
        Intrinsics.checkNotNullParameter((Object)jiraGroupWithPermissionsMapper, (String)"jiraGroupWithPermissionsMapper");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)usersWithMembershipsExtractor, (String)"usersWithMembershipsExtractor");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReader, (String)"jsmCustomerReader");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        this.exportFacade = exportFacade;
        this.userManager = userManager;
        this.projectManager = projectManager;
        this.jiraUsersAndGroupsService = jiraUsersAndGroupsService;
        this.discoveryService = discoveryService;
        this.jiraGroupReader = jiraGroupReader;
        this.jiraGroupWithPermissionsMapper = jiraGroupWithPermissionsMapper;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.usersWithMembershipsExtractor = usersWithMembershipsExtractor;
        this.jsmCustomerReader = jsmCustomerReader;
        this.migrationFeatures = migrationFeatures;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.jsmUtility = jsmUtility;
        this.dataFiltersContextService = dataFiltersContextService;
    }

    @NotNull
    public final UsersGroupsExtractionResult extract(@NotNull Task task, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2, @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, task, false, 2, null);
        List list = plan2.getAdvancedRoadmapsPlanIds();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List advancedRoadmapsPlanIds = list;
        return this.extract(plan2.getProjectKeys(), plan2.getUsersGroupsMigrationOption(), plan2.getProjectDataMigrationMode(), plan2.getMigrationType(), advancedRoadmapsPlanIds, this.migrationTaskMetadataProvider.get(task), onProgressUpdate2, new CrossProjectConfig(new CrossProjectExportConfig(plan2.getCrossProjectBoardsAndFiltersMigrationOption(), plan2.getDashboardsMigrationMode())), plan2.getMigrateArchivedIssues(), planId, DataFiltersContextService.getDataFilterContext$default(this.dataFiltersContextService, plan2.getProjectDataMigrationMode(), plan2.getIssueFilters(), null, 4, null));
    }

    public static /* synthetic */ UsersGroupsExtractionResult extract$default(UsersGroupsExtractor usersGroupsExtractor, Task task, Function1 function1, String string, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = extract.1.INSTANCE;
        }
        return usersGroupsExtractor.extract(task, (Function1<? super ExportUpdate, Unit>)function1, string);
    }

    @NotNull
    public final UsersGroupsExtractionResult extract(@NotNull String id, @NotNull List<String> projectKeys, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull ProjectDataMigrationMode projectDataMigrationMode, @NotNull MigrationType migrationType, @NotNull ApplicationUser startedUser, @Nullable List<Long> advancedRoadmapsPlanIds, @Nullable CrossProjectConfig crossProjectConfig, @Nullable Boolean migrateArchivedIssues, @Nullable String planId, @NotNull DataFilterContext dataFilterContext, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
        Intrinsics.checkNotNullParameter((Object)startedUser, (String)"startedUser");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        MigrationTaskMetadata migrationTaskMetadata2 = MigrationTaskMetadata.Companion.dummyMigrationMetadata$default(MigrationTaskMetadata.Companion, id, startedUser, null, 4, null);
        return this.extract(projectKeys, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, advancedRoadmapsPlanIds, migrationTaskMetadata2, onProgressUpdate2, crossProjectConfig, migrateArchivedIssues, planId, dataFilterContext);
    }

    public static /* synthetic */ UsersGroupsExtractionResult extract$default(UsersGroupsExtractor usersGroupsExtractor, String string, List list, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, ApplicationUser applicationUser, List list2, CrossProjectConfig crossProjectConfig, Boolean bl, String string2, DataFilterContext dataFilterContext, Function1 function1, int n, Object object) {
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        if ((n & 0x200) != 0) {
            string2 = null;
        }
        if ((n & 0x400) != 0) {
            dataFilterContext = new DataFilterContext(null, null, null, 7, null);
        }
        if ((n & 0x800) != 0) {
            function1 = extract.2.INSTANCE;
        }
        return usersGroupsExtractor.extract(string, list, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, applicationUser, list2, crossProjectConfig, bl, string2, dataFilterContext, (Function1<? super ExportUpdate, Unit>)function1);
    }

    private final UsersGroupsExtractionResult extract(List<String> projectKeys, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, List<Long> advancedRoadmapsPlanIds, MigrationTaskMetadata taskMetadata, Function1<? super ExportUpdate, Unit> onProgressUpdate2, CrossProjectConfig crossProjectConfig, Boolean migrateArchivedIssues, String planId, DataFilterContext dataFilterContext) {
        UsersGroupsExtractionResult usersGroupsExtractionResult;
        ScopedUserExtractor referencedUserReader = new ScopedUserExtractor(this.exportFacade, projectKeys, taskMetadata, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, onProgressUpdate2, this.projectManager, advancedRoadmapsPlanIds, this.jsmCustomerReader, this.jiraThreadLocalUtil, this.migrationFeatures, crossProjectConfig, migrateArchivedIssues, planId, dataFilterContext);
        log.info("User group extraction started in User migration mode: {} for migrationId: {}", (Object)usersGroupsMigrationOption.getMode(), (Object)taskMetadata.getMigrationId());
        switch (WhenMappings.$EnumSwitchMapping$0[usersGroupsMigrationOption.getMode().ordinal()]) {
            case 1: {
                JiraUserGroupMigrationData userGroupMigrationData = this.jiraUsersAndGroupsService.usersAndGroupsMigrationData(usersGroupsMigrationOption, onProgressUpdate2, planId);
                log.info("User group extraction finished for mode {} for migration {}", (Object)usersGroupsMigrationOption.getMode(), (Object)taskMetadata.getMigrationId());
                Pair<Sequence<JiraUser>, List<JiraGroupWithPermissions>> pair = this.getScopedCustomers(referencedUserReader, usersGroupsMigrationOption, onProgressUpdate2, taskMetadata);
                Sequence referencedCustomers = (Sequence)pair.component1();
                List customerPermissions = (List)pair.component2();
                usersGroupsExtractionResult = new UsersGroupsExtractionResult(new UsersWithReferences(CollectionsKt.plus((Collection)userGroupMigrationData.getUsers(), (Sequence)referencedCustomers)), new GroupsWithReferences(CollectionsKt.plus((Collection)userGroupMigrationData.getGroups(), (Iterable)customerPermissions)), userGroupMigrationData.getMembership(), ExportStatistics.Companion.getEMPTY(), false);
                break;
            }
            case 2: {
                UsersAndGroupsWithReferences usersAndGroupsWithReferences = referencedUserReader.getAllUsersGroupsWithReferences();
                usersGroupsExtractionResult = this.getReferencedExtractionResult(usersAndGroupsWithReferences, usersGroupsMigrationOption, onProgressUpdate2);
                break;
            }
            case 3: {
                throw new IllegalStateException("UsersGroupsExtractor.extract shouldn't be called when migrationMode is NONE");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        UsersGroupsExtractionResult usersGroupsExtractionResult2 = usersGroupsExtractionResult;
        return this.alsoLogUsersAndGroupsBreakdown(UsersGroupsExtractionResult.copy$default(usersGroupsExtractionResult2, usersGroupsExtractionResult2.getUsersWithReferences(), null, null, null, false, 30, null));
    }

    static /* synthetic */ UsersGroupsExtractionResult extract$default(UsersGroupsExtractor usersGroupsExtractor, List list, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, List list2, MigrationTaskMetadata migrationTaskMetadata2, Function1 function1, CrossProjectConfig crossProjectConfig, Boolean bl, String string, DataFilterContext dataFilterContext, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            function1 = extract.3.INSTANCE;
        }
        if ((n & 0x400) != 0) {
            dataFilterContext = new DataFilterContext(null, null, null, 7, null);
        }
        return usersGroupsExtractor.extract(list, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, list2, migrationTaskMetadata2, (Function1<? super ExportUpdate, Unit>)function1, crossProjectConfig, bl, string, dataFilterContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Sequence<JiraUser>, List<JiraGroupWithPermissions>> getScopedCustomers(@NotNull ScopedUserExtractor referencedUserReader, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2, @NotNull MigrationTaskMetadata taskMetadata) {
        Intrinsics.checkNotNullParameter((Object)referencedUserReader, (String)"referencedUserReader");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)taskMetadata, (String)"taskMetadata");
        Sequence referencedCustomers = SequencesKt.emptySequence();
        List<JiraGroupWithPermissions> customerPermissions = CollectionsKt.emptyList();
        if (MigrationModeUtil.INSTANCE.doNotMigrateCustomer(usersGroupsMigrationOption) && this.jsmUtility.isJsmInstalled()) {
            void $this$mapTo$iv$iv;
            log.info("Extracting scoped customers for JSW projects for JSD migration mode {} and migrationId {}", (Object)usersGroupsMigrationOption.getMode(), (Object)taskMetadata.getMigrationId());
            UsersAndGroupsWithReferences referencedEntities = referencedUserReader.getAllUsersGroupsWithReferences();
            Iterable $this$map$iv = referencedEntities.getGroups().names();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JiraGroup((String)p0));
            }
            List jiraGroups = (List)destination$iv$iv;
            customerPermissions = this.buildGroupsPermissions(jiraGroups, onProgressUpdate2);
            referencedCustomers = SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)referencedEntities.getCustomers().names()), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
                final /* synthetic */ UsersGroupsExtractor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final ApplicationUser invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return UsersGroupsExtractor.access$getUserManager$p(this.this$0).getUserByKey(it);
                }
            })), (Function1)getScopedCustomers.3.INSTANCE);
        }
        return new Pair((Object)referencedCustomers, (Object)customerPermissions);
    }

    public static /* synthetic */ Pair getScopedCustomers$default(UsersGroupsExtractor usersGroupsExtractor, ScopedUserExtractor scopedUserExtractor, UsersGroupsMigrationOption usersGroupsMigrationOption, Function1 function1, MigrationTaskMetadata migrationTaskMetadata2, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = getScopedCustomers.1.INSTANCE;
        }
        return usersGroupsExtractor.getScopedCustomers(scopedUserExtractor, usersGroupsMigrationOption, (Function1<? super ExportUpdate, Unit>)function1, migrationTaskMetadata2);
    }

    @NotNull
    public final UsersGroupsExtractionResult getReferencedExtractionResult(@NotNull UsersAndGroupsWithReferences usersAndGroupsWithReferences, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)usersAndGroupsWithReferences, (String)"usersAndGroupsWithReferences");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return this.toUserGroupExtractionResult(usersAndGroupsWithReferences, onProgressUpdate2, usersGroupsMigrationOption);
    }

    public static /* synthetic */ UsersGroupsExtractionResult getReferencedExtractionResult$default(UsersGroupsExtractor usersGroupsExtractor, UsersAndGroupsWithReferences usersAndGroupsWithReferences, UsersGroupsMigrationOption usersGroupsMigrationOption, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = getReferencedExtractionResult.1.INSTANCE;
        }
        return usersGroupsExtractor.getReferencedExtractionResult(usersAndGroupsWithReferences, usersGroupsMigrationOption, (Function1<? super ExportUpdate, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final UsersGroupsExtractionResult alsoLogUsersAndGroupsBreakdown(UsersGroupsExtractionResult $this$alsoLogUsersAndGroupsBreakdown) {
        void $this$filterTo$iv$iv;
        int totalCount = ((Collection)$this$alsoLogUsersAndGroupsBreakdown.getUsersWithReferences().getUsers()).size();
        Iterable $this$filter$iv = $this$alsoLogUsersAndGroupsBreakdown.getUsersWithReferences().getUsers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JiraUser it = (JiraUser)element$iv$iv;
            boolean bl = false;
            if (!it.getActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int activeCount = ((Collection)((List)destination$iv$iv)).size();
        log.info("User extraction breakdown, total=" + totalCount + " and active=" + activeCount);
        log.info("Group extraction breakdown, total=" + $this$alsoLogUsersAndGroupsBreakdown.getGroupsWithReferences().getGroups().size());
        return $this$alsoLogUsersAndGroupsBreakdown;
    }

    /*
     * WARNING - void declaration
     */
    private final UsersGroupsExtractionResult toUserGroupExtractionResult(UsersAndGroupsWithReferences $this$toUserGroupExtractionResult, Function1<? super ExportUpdate, Unit> onProgressUpdate2, UsersGroupsMigrationOption usersGroupsMigrationOption) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object;
        Object object2;
        Object object3;
        UsersWithReferences usersWithReferences;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toUserGroupExtractionResult.getGroups().names();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JiraGroup(string));
        }
        List groupsToMigrate = (List)destination$iv$iv;
        List<JiraGroupWithPermissions> groupsWithPermissions = this.buildGroupsPermissions(groupsToMigrate, onProgressUpdate2);
        Pair<IdsWithReferences, List<JiraGroupWithMemberships>> pair = this.usersWithMembershipsExtractor.fullUserSetAndMemberships($this$toUserGroupExtractionResult.getUsers(), groupsToMigrate, usersGroupsMigrationOption, onProgressUpdate2);
        IdsWithReferences fullUserSet = (IdsWithReferences)pair.component1();
        List memberships = (List)pair.component2();
        if (this.migrationFeatures.getEnableFilteringOutNullUser()) {
            Map allUsersWithReferences = new LinkedHashMap();
            for (Map.Entry entry : fullUserSet.getMap().entrySet()) {
                String userKey = (String)entry.getKey();
                References value = (References)entry.getValue();
                ApplicationUser user = this.userManager.getUserByKey(userKey);
                if (user != null) {
                    User user2 = user.getDirectoryUser();
                    Intrinsics.checkNotNullExpressionValue((Object)user2, (String)"getDirectoryUser(...)");
                    JiraUser jiraUser = JiraUser.Companion.fromUser(user2, userKey);
                    allUsersWithReferences.put(jiraUser, value);
                    continue;
                }
                log.info("User with the key " + userKey + " was not found.");
            }
            usersWithReferences = new UsersWithReferences(allUsersWithReferences);
        } else {
            Map<String, References> $this$mapKeys$iv = fullUserSet.getMap();
            boolean $i$f$mapKeys = false;
            Map<String, References> map = $this$mapKeys$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = map.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object3 = destination$iv$iv2;
                boolean bl = false;
                String userKey = (String)entry.getKey();
                ApplicationUser applicationUser = this.userManager.getUserByKey(userKey);
                Intrinsics.checkNotNull((Object)applicationUser);
                User user = applicationUser.getDirectoryUser();
                Intrinsics.checkNotNullExpressionValue((Object)user, (String)"getDirectoryUser(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                JiraUser jiraUser = JiraUser.Companion.fromUser(user, userKey);
                Map map2 = object3;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map2.put(jiraUser, v);
            }
            Map map3 = destination$iv$iv2;
            usersWithReferences = new UsersWithReferences(map3);
        }
        UsersWithReferences usersWithReferences2 = usersWithReferences;
        Iterable $this$associateWith$iv = groupsWithPermissions;
        boolean bl = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void group;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (JiraGroupWithPermissions)element$iv$iv;
            object2 = element$iv$iv;
            object3 = result$iv;
            boolean bl2 = false;
            object = $this$toUserGroupExtractionResult.getGroups().get(group.getName());
            object3.put(object2, object);
        }
        Map map = result$iv;
        GroupsWithReferences groupsWithReferences = new GroupsWithReferences(map);
        $this$associateWith$iv = memberships;
        object2 = groupsWithReferences;
        object3 = usersWithReferences2;
        boolean bl3 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateWithTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map4 = destination$iv$iv3;
            JiraGroupWithMemberships it = (JiraGroupWithMemberships)element$iv$iv;
            boolean bl4 = false;
            Pair pair2 = TuplesKt.to((Object)it.getGroup().getName(), it.getMemberKeys());
            map4.put(pair2.getFirst(), pair2.getSecond());
        }
        object = destination$iv$iv3;
        boolean bl5 = $this$toUserGroupExtractionResult.getHasExportError();
        ExportStatistics exportStatistics = $this$toUserGroupExtractionResult.getStatistics();
        Object object4 = object;
        Object object5 = object2;
        Object object6 = object3;
        return new UsersGroupsExtractionResult((UsersWithReferences)object6, (GroupsWithReferences)object5, (Map<String, ? extends Set<String>>)object4, exportStatistics, bl5);
    }

    private final List<JiraGroupWithPermissions> buildGroupsPermissions(Collection<JiraGroup> groups2, Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Map groupsAccesses = JiraGroupReader.groupAccessesForMigration$default(this.jiraGroupReader, groups2, null, 2, null);
        return SequencesKt.toList((Sequence)SequencesKt.mapIndexed(this.jiraGroupWithPermissionsMapper.fromGroupAccesses(groupsAccesses), (Function2)((Function2)new Function2<Integer, JiraGroupWithPermissions, JiraGroupWithPermissions>(onProgressUpdate2){
            final /* synthetic */ Function1<ExportUpdate, Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(2);
            }

            @NotNull
            public final JiraGroupWithPermissions invoke(int i, @NotNull JiraGroupWithPermissions group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                this.$onProgressUpdate.invoke((Object)new ExportUpdate.GroupExported(i));
                return group;
            }
        })));
    }

    public static final /* synthetic */ UserManager access$getUserManager$p(UsersGroupsExtractor $this) {
        return $this.userManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UsersGroupsMigrationOption.MigrationMode.values().length];
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.REFERENCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

