/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDto;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import com.atlassian.jira.migration.email.DomainScanService;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.model.DomainScan;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.events.FeatureFlagCollectionServiceStarted;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStartedWithConfigs;
import com.atlassian.jira.migration.events.UsersAndGroupsUploadFailed;
import com.atlassian.jira.migration.events.UsersAndGroupsUploadStarted;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.features.StatsigDynamicConfigs;
import com.atlassian.jira.migration.fx3.api.Fx3PluginClient;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001a\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\u001fj\u0002` J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010&\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\u001fj\u0002` R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;", "", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "exportErrorRepository", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "fx3PluginClient", "Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;", "domainScanService", "Lcom/atlassian/jira/migration/email/DomainScanService;", "trustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;Lcom/atlassian/jira/migration/email/DomainScanService;Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;)V", "buildDeletedUserMapping", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserInfo;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "onProgressUpdate", "Lkotlin/Function0;", "", "postFailedEvent", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "postFeatureFlagsEvents", "postMigrationConfigEvent", "postStartEvent", "sendFailedEvent", "sendSuccessfulEvent", "storeStackTrace", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersGroupsProcessorMetricService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersGroupsProcessorMetricService.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n13309#2,2:132\n*S KotlinDebug\n*F\n+ 1 UsersGroupsProcessorMetricService.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService\n*L\n97#1:132,2\n*E\n"})
public final class UsersGroupsProcessorMetricService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final ExportErrorRepository exportErrorRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final Fx3PluginClient fx3PluginClient;
    @NotNull
    private final DomainScanService domainScanService;
    @NotNull
    private final EmailTrustedDomainService trustedDomainService;
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILED = "Failed";

    @Inject
    public UsersGroupsProcessorMetricService(@NotNull MetricsEventService metricsEventService, @NotNull ExportErrorRepository exportErrorRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationEventBus migrationEventBus, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull Fx3PluginClient fx3PluginClient, @NotNull DomainScanService domainScanService, @NotNull EmailTrustedDomainService trustedDomainService) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)exportErrorRepository, (String)"exportErrorRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)fx3PluginClient, (String)"fx3PluginClient");
        Intrinsics.checkNotNullParameter((Object)domainScanService, (String)"domainScanService");
        Intrinsics.checkNotNullParameter((Object)trustedDomainService, (String)"trustedDomainService");
        this.metricsEventService = metricsEventService;
        this.exportErrorRepository = exportErrorRepository;
        this.migrationFeatures = migrationFeatures;
        this.migrationEventBus = migrationEventBus;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.fx3PluginClient = fx3PluginClient;
        this.domainScanService = domainScanService;
        this.trustedDomainService = trustedDomainService;
    }

    public final void sendSuccessfulEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        MetricsEventService.sendEventForTask$default(this.metricsEventService, task.getMigrationTask().getMigrationTaskType(), SUCCESS, 0.0, 4, null);
    }

    public final void sendFailedEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        MetricsEventService.sendEventForTask$default(this.metricsEventService, task.getMigrationTask().getMigrationTaskType(), FAILED, 0.0, 4, null);
    }

    public final void storeStackTrace(@NotNull Task task, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.exportErrorRepository.save(new ExportErrorDto(Instant.now().toEpochMilli(), task.getCloudId(), task.getMigrationId(), null, StringsKt.substringBefore((String)task.getTaskId(), (String)"#", (String)"unknown_Task"), ExceptionsKt.stackTraceToString((Throwable)ex), 8, null));
    }

    public final void postStartEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.migrationEventBus.post(new UsersAndGroupsUploadStarted(task.getCloudId(), task.getMigrationId()));
    }

    public final void postMigrationConfigEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        int csvReviewedDomains = this.trustedDomainService.countByReviewMethod(EmailTrustedDomain.ReviewMethod.CSV);
        int manuallyReviewedDomains = this.trustedDomainService.countByReviewMethod(EmailTrustedDomain.ReviewMethod.MANUAL);
        DomainScan mostRecentDomainScan = this.domainScanService.getRecentlyFinished();
        UDCMode uDCMode = this.globalEmailFixesConfigService.getConfirmedUdcModeConfig();
        DomainScan domainScan = mostRecentDomainScan;
        DomainScan domainScan2 = mostRecentDomainScan;
        this.migrationEventBus.post(new MigrationStartedWithConfigs(task.getCloudId(), task.getMigrationId(), this.globalEmailFixesConfigService.getInvalidEmailsConfig().getOnMigration().name(), this.globalEmailFixesConfigService.getDuplicatedEmailsConfig().getOnMigration().name(), uDCMode != null ? uDCMode.name() : null, domainScan != null ? domainScan.getBlockedDomainsCount() : 0L, domainScan2 != null ? domainScan2.getDistinctDomainsCount() : 0L, manuallyReviewedDomains, csvReviewedDomains));
    }

    public final void postFeatureFlagsEvents(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Map eventMapWithValue = new LinkedHashMap();
        StatsigDynamicConfigs[] $this$forEach$iv = StatsigDynamicConfigs.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object value;
            StatsigDynamicConfigs element$iv;
            StatsigDynamicConfigs it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull(it.getValue(this.fx3PluginClient), (String)"null cannot be cast to non-null type kotlin.Any");
            eventMapWithValue.put(it.getConfigKey(), value);
        }
        this.migrationEventBus.post(new FeatureFlagCollectionServiceStarted(task.getCloudId(), task.getMigrationId(), this.migrationFeatures.all(), eventMapWithValue));
    }

    public final void postFailedEvent(@NotNull Task task, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.migrationEventBus.post(new UsersAndGroupsUploadFailed(task.getCloudId(), task.getMigrationId(), ex.getMessage()));
    }

    @NotNull
    public final List<UserInfo> buildDeletedUserMapping(@NotNull Task task, @NotNull Function0<Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return this.tombstoneAccountManager.buildDeletedUserMappingForAllTombStones(task, onProgressUpdate2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService$Companion;", "", "()V", "FAILED", "", "SUCCESS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

