/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraServerUserMappings;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUsersAndGroupsService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsExtractor;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$\u00b2\u0006\n\u0010\"\u001a\u00020\u001fX\u008a\u0084\u0002\u00b2\u0006\n\u0010%\u001a\u00020\u0018X\u008a\u0084\u0002"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorService;", "", "usersAndGroupsService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;", "usersGroupsExtractor", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsExtractor;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "extractUsersGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "log", "Lorg/slf4j/Logger;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "planId", "", "getMigrationScope", "mapUserEmailToUserInfo", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraServerUserMappings;", "usersForUserMapping", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "retrieveLazyPlan", "Lcom/atlassian/jira/migration/plan/Plan;", "shouldPublishTombStoneMappings", "", "plan", "userMigrationNotRequired", "jira-migration-plugin", "migrationScopeId"})
public final class UsersGroupsProcessorService {
    @NotNull
    private final JiraUsersAndGroupsService usersAndGroupsService;
    @NotNull
    private final UsersGroupsExtractor usersGroupsExtractor;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public UsersGroupsProcessorService(@NotNull JiraUsersAndGroupsService usersAndGroupsService, @NotNull UsersGroupsExtractor usersGroupsExtractor, @NotNull DiscoveryService discoveryService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)usersAndGroupsService, (String)"usersAndGroupsService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsExtractor, (String)"usersGroupsExtractor");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.usersAndGroupsService = usersAndGroupsService;
        this.usersGroupsExtractor = usersGroupsExtractor;
        this.discoveryService = discoveryService;
        this.migrationScopeManager = migrationScopeManager;
        this.migrationFeatures = migrationFeatures;
    }

    public final boolean userMigrationNotRequired(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return plan2.isLegacyAttachmentsOnly() || plan2.isV2AttachmentsOnly();
    }

    public final boolean shouldPublishTombStoneMappings(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return !this.userMigrationNotRequired(plan2) && !this.migrationFeatures.getDisablePublishingTombstoneMappings();
    }

    @NotNull
    public final JiraServerUserMappings mapUserEmailToUserInfo(@NotNull JiraUserGroupMigrationData usersForUserMapping2, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)usersForUserMapping2, (String)"usersForUserMapping");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return this.usersAndGroupsService.toJiraServerUserMappings(usersForUserMapping2, onProgressUpdate2);
    }

    @NotNull
    public final UsersGroupsExtractionResult extractUsersGroups(@NotNull Task task, @NotNull Logger log2, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2, @NotNull String planId) {
        UsersGroupsExtractionResult usersGroupsExtractionResult;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        UsersGroupsExtractionResult it = usersGroupsExtractionResult = this.usersGroupsExtractor.extract(task, onProgressUpdate2, planId);
        boolean bl = false;
        log2.info(task.getMigrationId() + '-' + task.getTaskId() + ": export users & groups complete: total numbers of users " + it.getUsers().size() + " to be migrated before filtering");
        return usersGroupsExtractionResult;
    }

    @NotNull
    public final Plan retrieveLazyPlan(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lazy plan$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Plan>(this, task){
            final /* synthetic */ UsersGroupsProcessorService this$0;
            final /* synthetic */ Task $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(0);
            }

            @NotNull
            public final Plan invoke() {
                return DiscoveryService.retrievePlanFor$default(UsersGroupsProcessorService.access$getDiscoveryService$p(this.this$0), this.$task, false, 2, null);
            }
        }));
        return UsersGroupsProcessorService.retrieveLazyPlan$lambda$1((Lazy<Plan>)plan$delegate);
    }

    @NotNull
    public final String getMigrationScope(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lazy migrationScopeId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this, task){
            final /* synthetic */ UsersGroupsProcessorService this$0;
            final /* synthetic */ Task $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return UsersGroupsProcessorService.access$getMigrationScopeManager$p(this.this$0).getMigrationScope(this.$task.getCloudSite());
            }
        }));
        return UsersGroupsProcessorService.getMigrationScope$lambda$2((Lazy<String>)migrationScopeId$delegate);
    }

    private static final Plan retrieveLazyPlan$lambda$1(Lazy<Plan> $plan$delegate) {
        Lazy<Plan> lazy = $plan$delegate;
        return (Plan)lazy.getValue();
    }

    private static final String getMigrationScope$lambda$2(Lazy<String> $migrationScopeId$delegate) {
        Lazy<String> lazy = $migrationScopeId$delegate;
        return (String)lazy.getValue();
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(UsersGroupsProcessorService $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ MigrationScopeManager access$getMigrationScopeManager$p(UsersGroupsProcessorService $this) {
        return $this.migrationScopeManager;
    }
}

