/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupProductAccess;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupPermission;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ProductPermission;
import com.atlassian.jira.migration.serverdataextractors.usergroup.References;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;", "", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "dropJwmProductAccessPermissions", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ProductPermission;", "productPermissions", "fetchCloudSiteFromContainerToken", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "containerToken", "", "isJwmInCloudSite", "", "cloudSite", "shouldSkipJwmAccessPermissionsInMigration", "skipJwmProductAccessPermissions", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "usersGroupsExtracted", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersGroupsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersGroupsUtil.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1603#2,9:90\n1855#2:99\n819#2:100\n847#2,2:101\n1856#2:104\n1612#2:105\n1360#2:106\n1446#2,5:107\n1747#2,3:112\n1#3:103\n*S KotlinDebug\n*F\n+ 1 UsersGroupsUtil.kt\ncom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil\n*L\n25#1:90,9\n25#1:99\n28#1:100\n28#1:101,2\n25#1:104\n25#1:105\n63#1:106\n63#1:107,5\n64#1:112,3\n25#1:103\n*E\n"})
public final class UsersGroupsUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final String JWM_PERMISSIONS_PURGE_LOG = "JWM product access permissions will be purged as JWM not installed on destination cloud site: ";
    private static final Logger log = LoggerFactory.getLogger(UsersGroupsUtil.class);

    @Inject
    public UsersGroupsUtil(@NotNull MigrationServiceClient migrationServiceClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationServiceClient = migrationServiceClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ProductPermission> dropJwmProductAccessPermissions(Set<ProductPermission> productPermissions) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = productPermissions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ProductPermission productPermission;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProductPermission productPermission2 = (ProductPermission)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)productPermission2.getName(), (Object)GroupProductAccess.JIRA_CORE_ACCESS.value())) {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = productPermission2.getPermissions();
                boolean $i$f$filterNot = false;
                Iterable iterable2 = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                    boolean bl3;
                    JiraGroupPermission it = (JiraGroupPermission)((Object)element$iv$iv2);
                    boolean bl4 = false;
                    boolean it2 = bl3 = it == JiraGroupPermission.PRODUCT_ACCESS;
                    boolean bl5 = false;
                    log.info("Dropping JWM product access permission for group " + productPermission2.getName());
                    if (bl3) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                Set filteredPermissions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                productPermission = filteredPermissions.isEmpty() ? null : new ProductPermission(productPermission2.getName(), filteredPermissions);
            } else {
                productPermission = productPermission2;
            }
            if (productPermission == null) continue;
            ProductPermission it$iv$iv = productPermission;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final UsersGroupsExtractionResult skipJwmProductAccessPermissions(@NotNull UsersGroupsExtractionResult usersGroupsExtracted) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsExtracted, (String)"usersGroupsExtracted");
        Map groupsWithReferenceWithoutJwmProductAccess2 = MapsKt.toMap((Iterable)usersGroupsExtracted.getGroupsWithReference().map((Function1)new Function1<Map.Entry<? extends JiraGroupWithPermissions, ? extends References>, Pair<? extends JiraGroupWithPermissions, ? extends References>>(this){
            final /* synthetic */ UsersGroupsUtil this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<JiraGroupWithPermissions, References> invoke(@NotNull Map.Entry<JiraGroupWithPermissions, References> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                JiraGroupWithPermissions jiraGroupWithPermissions = entry.getKey();
                References references = entry.getValue();
                Set filteredProductPermissions = UsersGroupsUtil.access$dropJwmProductAccessPermissions(this.this$0, jiraGroupWithPermissions.getProducts());
                return TuplesKt.to((Object)JiraGroupWithPermissions.copy$default(jiraGroupWithPermissions, null, filteredProductPermissions, 1, null), (Object)references);
            }
        }));
        UsersGroupsExtractionResult updatedUsersGroupsExtractedResult = UsersGroupsExtractionResult.copy$default(usersGroupsExtracted, null, new GroupsWithReferences(groupsWithReferenceWithoutJwmProductAccess2), null, null, false, 29, null);
        return updatedUsersGroupsExtractedResult;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJwmInCloudSite(CloudSite cloudSite2) {
        boolean bl;
        if (cloudSite2 == null) {
            return false;
        }
        try {
            boolean bl2;
            block7: {
                void $this$flatMapTo$iv$iv;
                Product[] productArray = new Product[]{Product.JIRA_CORE};
                SiteDetailsResponse siteDetails = this.migrationServiceClient.fetchSiteDetails(cloudSite2.getContainerToken(), SiteDetailsRequest.Companion.requestDetailsFor(cloudSite2.getCloudId(), productArray));
                Iterable $this$flatMap$iv = siteDetails.getSites();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    SiteDetailsWithCloudId it = (SiteDetailsWithCloudId)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it.getProducts();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List productsList = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                Iterable $this$any$iv = productsList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TcsProductInfo it = (TcsProductInfo)element$iv;
                        boolean bl4 = false;
                        if (!(it.getProductKey() == Product.JIRA_CORE)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            boolean productExists = bl2;
            log.info(productExists ? "JWM product access permissions will not be purged as JWM installed on destination cloud site: " + cloudSite2.getCloudId() : JWM_PERMISSIONS_PURGE_LOG + cloudSite2.getCloudId());
            bl = productExists;
        }
        catch (Exception e) {
            log.info(JWM_PERMISSIONS_PURGE_LOG + cloudSite2.getCloudId());
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final CloudSite fetchCloudSiteFromContainerToken(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        return this.cloudSiteRepository.getSiteByContainerToken(containerToken);
    }

    public final boolean shouldSkipJwmAccessPermissionsInMigration(@Nullable CloudSite cloudSite2) {
        return this.migrationFeatures.getSkipJWMProductAccessPermissionsMigration() && !this.isJwmInCloudSite(cloudSite2);
    }

    public static final /* synthetic */ Set access$dropJwmProductAccessPermissions(UsersGroupsUtil $this, Set productPermissions) {
        return $this.dropJwmProductAccessPermissions(productPermissions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil$Companion;", "", "()V", "JWM_PERMISSIONS_PURGE_LOG", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

