/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.usersgroups;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.UsersGroupsTransferMigrationTask;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.shadow.db.UsersExportFinalStatus;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.usersgroups.AbstractPlatformUsersGroupProcessor;
import com.atlassian.jira.migration.workers.usersgroups.AbstractUsersGroupsProcessor;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsProcessorMetricService;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsProcessorService;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsUtil;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020/H\u0016J\b\u0010A\u001a\u00020/H\u0016J\u0010\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u000203H\u0002J\u0012\u0010D\u001a\u00020/2\b\u0010E\u001a\u0004\u0018\u000103H\u0016J\b\u0010F\u001a\u00020/H\u0002J\b\u0010G\u001a\u00020/H\u0007R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\n '*\u0004\u0018\u00010&0&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001c\u00102\u001a\u0002038\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b4\u00105\u001a\u0004\b6\u00107R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/atlassian/jira/migration/workers/usersgroups/V3UsersGroupsProcessor;", "Lcom/atlassian/jira/migration/workers/usersgroups/AbstractPlatformUsersGroupProcessor;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "usersGroupsProcessorService", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorService;", "usersGroupsProcessorMetricService", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;", "userEmailFixer", "Lcom/atlassian/jira/migration/email/UserEmailFixer;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "usersGroupsUtil", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorService;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsProcessorMetricService;Lcom/atlassian/jira/migration/email/UserEmailFixer;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Ljava/util/concurrent/ScheduledExecutorService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;)V", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "getMigrationScopeManager", "()Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "operationKeyPrefix", "", "getOperationKeyPrefix$annotations", "()V", "getOperationKeyPrefix", "()Ljava/lang/String;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "usersAndGroupsTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/UsersGroupsTransferMigrationTask;", "getHeartbeatFrequency", "", "process", "sendFinalStatus", "sendFinalStatusForShadowMigration", "migrationId", "sendHeartbeat", "msg", "setHeartbeatScheduler", "shutdown", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV3UsersGroupsWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3UsersGroupsWorker.kt\ncom/atlassian/jira/migration/workers/usersgroups/V3UsersGroupsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class V3UsersGroupsProcessor
extends AbstractPlatformUsersGroupProcessor {
    @NotNull
    private final Task task;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    @NotNull
    private final UsersGroupsProcessorService usersGroupsProcessorService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;
    @NotNull
    private final UsersGroupsTransferMigrationTask usersAndGroupsTask;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;
    @NotNull
    private final String operationKeyPrefix;
    @NotNull
    private final Function1<ExportUpdate, Unit> onProgressUpdate;

    public V3UsersGroupsProcessor(@NotNull Task task, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull PlatformService platformService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull UsersGroupsProcessorService usersGroupsProcessorService, @NotNull UsersGroupsProcessorMetricService usersGroupsProcessorMetricService, @NotNull UserEmailFixer userEmailFixer, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull UserExportMismatchService userExportMismatchService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DiscoveryService discoveryService, @NotNull ScheduledExecutorService heartbeatScheduler, @NotNull MigrationFeatures migrationFeatures, @NotNull UsersGroupsUtil usersGroupsUtil) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsProcessorService, (String)"usersGroupsProcessorService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsProcessorMetricService, (String)"usersGroupsProcessorMetricService");
        Intrinsics.checkNotNullParameter((Object)userEmailFixer, (String)"userEmailFixer");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)usersGroupsUtil, (String)"usersGroupsUtil");
        super(task, usersMigrationServiceClient, platformService, userExportMismatchService, migAssetStatsService, usersGroupsProcessorService, usersGroupsProcessorMetricService, userEmailFixer, metricsEventService, jiraEventDetectionService, migrationScopeManager, usersGroupsUtil);
        this.task = task;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.platformService = platformService;
        this.migAssetStatsService = migAssetStatsService;
        this.usersGroupsProcessorService = usersGroupsProcessorService;
        this.migrationScopeManager = migrationScopeManager;
        this.userExportMismatchService = userExportMismatchService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.discoveryService = discoveryService;
        this.heartbeatScheduler = heartbeatScheduler;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(V3UsersGroupsProcessor.class);
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.UsersGroupsTransferMigrationTask");
        this.usersAndGroupsTask = (UsersGroupsTransferMigrationTask)migrationTask;
        this.transferId = new TransferId(this.usersAndGroupsTask.getTransferId());
        this.heartbeater = new PlatformHeartbeater(this.platformService, this.getContainerToken(), this.usersAndGroupsTask.getHeartbeatUrl(), null, null, 24, null);
        this.progressUpdater = new PlatformProgressUpdater(this.platformService, this.getMigrationId(), this.transferId, this.getContainerToken(), null, null, 48, null);
        this.operationKeyPrefix = "user-" + this.task.getMigrationId() + '-' + UUID.randomUUID();
        this.onProgressUpdate = (Function1)new Function1<ExportUpdate, Unit>(this){
            final /* synthetic */ V3UsersGroupsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ExportUpdate it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AbstractUsersGroupsProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                ExportUpdate exportUpdate = it;
                if (exportUpdate instanceof ExportUpdate.UserExported) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usersExported", (Object)((ExportUpdate.UserExported)it).getSuccessfullyCompleted()), TuplesKt.to((Object)"groupsExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("groupsExported"))};
                    PlatformProgressUpdater.sendProgressUpdate$default(V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0), null, null, MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)(V3UsersGroupsProcessor.access$getMigrationFeatures$p(this.this$0).getEnableMembershipsProgress() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("membershipsExported"))) : MapsKt.emptyMap())), false, 11, null);
                } else if (exportUpdate instanceof ExportUpdate.GroupExported) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usersExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("usersExported")), TuplesKt.to((Object)"groupsExported", (Object)((ExportUpdate.GroupExported)it).getSuccessfullyCompleted())};
                    PlatformProgressUpdater.sendProgressUpdate$default(V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0), null, null, MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)(V3UsersGroupsProcessor.access$getMigrationFeatures$p(this.this$0).getEnableMembershipsProgress() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("membershipsExported"))) : MapsKt.emptyMap())), false, 11, null);
                } else if (exportUpdate instanceof ExportUpdate.MembershipExported && V3UsersGroupsProcessor.access$getMigrationFeatures$p(this.this$0).getEnableMembershipsProgress()) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usersExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("usersExported")), TuplesKt.to((Object)"groupsExported", (Object)V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0).getProgressEntityCount("groupsExported"))};
                    PlatformProgressUpdater.sendProgressUpdate$default(V3UsersGroupsProcessor.access$getProgressUpdater$p(this.this$0), null, null, MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)(V3UsersGroupsProcessor.access$getMigrationFeatures$p(this.this$0).getEnableMembershipsProgress() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)((ExportUpdate.MembershipExported)it).getSuccessfullyCompleted())) : MapsKt.emptyMap())), false, 11, null);
                }
            }
        };
    }

    @NotNull
    public final MigrationScopeManager getMigrationScopeManager() {
        return this.migrationScopeManager;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public String getOperationKeyPrefix() {
        return this.operationKeyPrefix;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOperationKeyPrefix$annotations() {
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    @Override
    @NotNull
    public Function1<ExportUpdate, Unit> getOnProgressUpdate() {
        return this.onProgressUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            super.process();
        }
        catch (Exception ex) {
            this.getLog().error("Failed to process user and group migration", (Throwable)ex);
            throw ex;
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        Map map;
        Map map2;
        MigrationFinalStatus migrationFinalStatus = MigrationFinalStatusRepository.getShadowMigrationMetadata$default(this.migrationFinalStatusRepository, migrationId, this.task.getMigrationTask().getMigrationTaskType(), null, 4, null);
        if (migrationFinalStatus == null) {
            PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        UsersExportFinalStatus cfr_ignored_0 = (UsersExportFinalStatus)finalStatus;
        Pair[] pairArray = this.progressUpdater;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"usersExported", (Object)((UsersExportFinalStatus)finalStatus).getUsersExported()), TuplesKt.to((Object)"groupsExported", (Object)((UsersExportFinalStatus)finalStatus).getGroupsExported())};
        Map map3 = MapsKt.mapOf((Pair[])pairArray2);
        if (this.migrationFeatures.getEnableMembershipsProgress()) {
            Long l = ((UsersExportFinalStatus)finalStatus).getMembershipsExported();
            Intrinsics.checkNotNull((Object)l);
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)l));
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map map4 = MapsKt.plus((Map)map3, (Map)map2);
        PlatformProgressUpdater.sendProgressUpdate$default((PlatformProgressUpdater)pairArray, null, null, map4, true, 3, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"usersGroupsExport", (Object)((UsersExportFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"usersGroupsMappings", (Object)((UsersExportFinalStatus)finalStatus).getDeletedUserMappingFile()), TuplesKt.to((Object)"tombstoneUsers", (Object)((UsersExportFinalStatus)finalStatus).getTombstoneUserFile()), TuplesKt.to((Object)"usersExported", (Object)((UsersExportFinalStatus)finalStatus).getUsersExported()), TuplesKt.to((Object)"groupsExported", (Object)((UsersExportFinalStatus)finalStatus).getGroupsExported())};
        Map map5 = MapsKt.mapOf((Pair[])pairArray);
        if (this.migrationFeatures.getEnableMembershipsProgress()) {
            Long l = ((UsersExportFinalStatus)finalStatus).getMembershipsExported();
            Intrinsics.checkNotNull((Object)l);
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)l));
        } else {
            map = MapsKt.emptyMap();
        }
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.plus((Map)map5, (Map)map), null, 4, null);
    }

    private final void setHeartbeatScheduler() {
        if (this.migrationFeatures.getEnableV3AsyncHeartbeat()) {
            this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ V3UsersGroupsProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    AbstractUsersGroupsProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                }
            }), this.task, MigrationProtocol.V3), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
        }
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        this.heartbeater.sendHeartbeat();
    }

    @Override
    public long getHeartbeatFrequency() {
        return 10L;
    }

    @Override
    public void sendFinalStatus() {
        long usersExported = this.progressUpdater.getProgressEntityCount("usersExported");
        long groupsExported = this.progressUpdater.getProgressEntityCount("groupsExported");
        long membershipsExported = this.progressUpdater.getProgressEntityCount("membershipsExported");
        Pair[] pairArray = this.progressUpdater;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"usersExported", (Object)usersExported), TuplesKt.to((Object)"groupsExported", (Object)groupsExported)};
        Map map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray2), (Map)(this.migrationFeatures.getEnableMembershipsProgress() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)membershipsExported)) : MapsKt.emptyMap()));
        PlatformProgressUpdater.sendProgressUpdate$default((PlatformProgressUpdater)pairArray, null, null, map, true, 3, null);
        String string = ((UUID)this.getMigrationId().getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationFinalStatusRepository.create$default(this.migrationFinalStatusRepository, string, new UsersExportFinalStatus(this.getUsersAndGroupsFile().getFileId(), this.getUserMappingFile().getFileId(), this.getTombstoneUsersFile().getFileId(), usersExported, groupsExported, this.migrationFeatures.getEnableMembershipsProgress() ? Long.valueOf(membershipsExported) : null), null, 4, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"usersGroupsExport", (Object)this.getUsersAndGroupsFile().getFileId()), TuplesKt.to((Object)"usersGroupsMappings", (Object)this.getUserMappingFile().getFileId()), TuplesKt.to((Object)"tombstoneUsers", (Object)this.getTombstoneUsersFile().getFileId()), TuplesKt.to((Object)"usersExported", (Object)usersExported), TuplesKt.to((Object)"groupsExported", (Object)groupsExported)};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)(this.migrationFeatures.getEnableMembershipsProgress() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"membershipsExported", (Object)membershipsExported)) : MapsKt.emptyMap())), null, 4, null);
    }

    public static final /* synthetic */ PlatformProgressUpdater access$getProgressUpdater$p(V3UsersGroupsProcessor $this) {
        return $this.progressUpdater;
    }

    public static final /* synthetic */ MigrationFeatures access$getMigrationFeatures$p(V3UsersGroupsProcessor $this) {
        return $this.migrationFeatures;
    }
}

